/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.udi.impl.sync;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IContextUDIMetadata;
import org.eclipse.higgins.idas.udi.impl.AbstractContextUDI;

public class PDSContextUDI
extends AbstractContextUDI {
    private static final long serialVersionUID = 6356129637679077736L;
    private static Pattern PATTERN_CONTEXTUDI = Pattern.compile("^sync://([^#]+)$");
    private String contextType;
    private IContextUDIMetadata contextUDIMetadata;

    public PDSContextUDI(String contextUDI, String contextType) throws IdASException {
        super(contextUDI);
        this.contextType = contextType;
        this.contextUDIMetadata = null;
    }

    public IContextUDIMetadata getContextUDIMetadata() {
        if (this.contextUDIMetadata == null) {
            final Matcher matcher = PATTERN_CONTEXTUDI.matcher(this.contextUDI);
            if (!matcher.matches()) {
                throw new RuntimeException("Cannot parse Context UDI: " + this.contextUDI);
            }
            this.contextUDIMetadata = new IContextUDIMetadata(){

                public String[] getTypes() throws IdASException {
                    return new String[]{PDSContextUDI.this.contextType};
                }

                public String[] getAuthNMaterialsTypes() throws IdASException {
                    return null;
                }

                public String getAuthNMaterials() throws IdASException {
                    return null;
                }

                public Map getConfiguration() throws IdASException {
                    HashMap<String, String> configuration = new HashMap<String, String>();
                    try {
                        configuration.put("context.file", "./pds/" + URLEncoder.encode(matcher.group(1), "UTF-8") + ".rdf");
                        configuration.put("context.uri", PDSContextUDI.this.contextUDI);
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new IdASException((Throwable)ex);
                    }
                    return configuration;
                }
            };
        }
        return this.contextUDIMetadata;
    }

    static boolean canParse(String contextUDI) {
        return PATTERN_CONTEXTUDI.matcher(contextUDI).matches();
    }
}

