/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.udi.impl.sync;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IContextUDIMetadata;
import org.eclipse.higgins.idas.udi.IEntityUDIMetadata;
import org.eclipse.higgins.idas.udi.impl.AbstractEntityUDI;

public class PDSEntityUDI
extends AbstractEntityUDI {
    private static final long serialVersionUID = 5313091735647688652L;
    private static Pattern PATTERN_ENTITYUDI = Pattern.compile("^sync://([^#]+)#([^#]+)$");
    private String contextType;
    private IEntityUDIMetadata entityUDIMetadata;

    public PDSEntityUDI(String entityUDI, String contextType) throws IdASException {
        super(entityUDI);
        this.contextType = contextType;
        this.entityUDIMetadata = null;
    }

    public IEntityUDIMetadata getEntityUDIMetadata() {
        if (this.entityUDIMetadata == null) {
            final Matcher matcher = PATTERN_ENTITYUDI.matcher(this.entityUDI);
            if (!matcher.matches()) {
                throw new RuntimeException("Cannot parse Entity UDI: " + this.entityUDI);
            }
            this.entityUDIMetadata = new IEntityUDIMetadata(){

                public IContextUDIMetadata getContextUDIMetadata() throws IdASException {
                    return new IContextUDIMetadata(){

                        public String[] getTypes() throws IdASException {
                            return new String[]{PDSEntityUDI.this.contextType};
                        }

                        public String[] getAuthNMaterialsTypes() throws IdASException {
                            return null;
                        }

                        public String getAuthNMaterials() throws IdASException {
                            return null;
                        }

                        public Map getConfiguration() throws IdASException {
                            HashMap<String, String> configuration = new HashMap<String, String>();
                            try {
                                configuration.put("context.file", "./pds/" + URLEncoder.encode(matcher.group(1), "UTF-8") + ".rdf");
                                configuration.put("context.uri", PDSEntityUDI.this.entityUDI.substring(0, PDSEntityUDI.this.entityUDI.indexOf("#")));
                            }
                            catch (UnsupportedEncodingException ex) {
                                throw new IdASException((Throwable)ex);
                            }
                            return configuration;
                        }
                    };
                }

                public String getEntityID() throws IdASException {
                    return PDSEntityUDI.this.entityUDI;
                }
            };
        }
        return this.entityUDIMetadata;
    }

    static boolean canParse(String entityUDI) {
        return PATTERN_ENTITYUDI.matcher(entityUDI).matches();
    }
}

