/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.udi.impl.uri;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IEntityUDIMetadata;
import org.eclipse.higgins.idas.udi.impl.AbstractEntityUDI;
import org.eclipse.higgins.idas.udi.impl.uri.URIEntityUDIMetadata;

public class URIEntityUDI
extends AbstractEntityUDI {
    private static final long serialVersionUID = 7896597422790522715L;
    private String entityUDI;
    private IEntityUDIMetadata entityUDIMetadata;

    public URIEntityUDI(String entityUDI) throws IdASException {
        super(entityUDI);
        this.entityUDI = entityUDI;
        this.entityUDIMetadata = null;
    }

    public IEntityUDIMetadata getEntityUDIMetadata() {
        if (this.entityUDIMetadata == null) {
            this.entityUDIMetadata = new URIEntityUDIMetadata(this.entityUDI);
        }
        return this.entityUDIMetadata;
    }

    static boolean canParse(String entityUDI) {
        URI uri;
        try {
            uri = new URI(entityUDI);
        }
        catch (URISyntaxException ex) {
            return false;
        }
        if (uri.getScheme() == null) {
            return false;
        }
        return uri.getFragment() == null;
    }
}

