/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.udi.impl.xri;

import java.util.ArrayList;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.util.XRDSContextUDIMetadata;
import org.openxri.XRI;
import org.openxri.resolve.Resolver;
import org.openxri.resolve.ResolverFlags;
import org.openxri.resolve.ResolverState;
import org.openxri.xml.Service;
import org.openxri.xml.XRD;

public class XRIContextUDIMetadata
extends XRDSContextUDIMetadata {
    private String contextUDI;
    private Resolver resolver;
    private boolean https;
    private boolean saml;
    private boolean cid;
    private boolean refs;

    XRIContextUDIMetadata(String contextUDI, Resolver resolver, boolean https, boolean saml, boolean cid, boolean refs) {
        this.contextUDI = contextUDI;
        this.resolver = resolver;
        this.https = https;
        this.saml = saml;
        this.cid = cid;
        this.refs = refs;
    }

    protected void resolve() throws IdASException {
        try {
            XRI xri = new XRI(this.contextUDI);
            ResolverFlags resolverFlags = new ResolverFlags();
            resolverFlags.setHttps(this.https);
            resolverFlags.setSaml(this.saml);
            resolverFlags.setCid(this.cid);
            resolverFlags.setRefs(this.refs);
            resolverFlags.setNoDefaultT(false);
            resolverFlags.setNoDefaultP(false);
            resolverFlags.setNoDefaultM(false);
            XRD xrd = this.resolver.resolveSEPToXRD(xri, "$context", null, resolverFlags, new ResolverState());
            ArrayList services = xrd.getSelectedServices().getList();
            if (services.size() > 0) {
                this.service = (Service)services.get(0);
            }
        }
        catch (Exception ex) {
            throw new IdASException("Cannot resolve XRI " + this.contextUDI + ": " + ex.getMessage(), (Throwable)ex);
        }
    }
}

