/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.udi.util;

import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import org.eclipse.higgins.configuration.xrds.ConfigurationHandler;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IContextUDIMetadata;
import org.openxri.xml.SEPType;
import org.openxri.xml.Service;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XRDSContextUDIMetadata
implements IContextUDIMetadata {
    protected Service service;

    protected abstract void resolve() throws IdASException;

    public final String[] getTypes() throws IdASException {
        if (this.service == null) {
            this.resolve();
        }
        if (this.service == null) {
            throw new IdASException("No service endpoint selected.");
        }
        ArrayList<String> types = new ArrayList<String>();
        for (int i = 0; i < this.service.getNumTypes(); ++i) {
            SEPType sepType = this.service.getTypeAt(i);
            if (sepType.getType() == null || sepType.getType().trim().equals("")) continue;
            types.add(sepType.getType());
        }
        return types.toArray(new String[types.size()]);
    }

    public final String[] getAuthNMaterialsTypes() throws IdASException {
        if (this.service == null) {
            this.resolve();
        }
        if (this.service == null) {
            throw new IdASException("No service endpoint selected.");
        }
        Vector authNMaterialsTypes = this.service.getOtherTagValues("AuthNMaterialsType");
        if (authNMaterialsTypes == null || authNMaterialsTypes.size() < 1) {
            return new String[0];
        }
        String[] authNMaterialsTypesStr = new String[authNMaterialsTypes.size()];
        for (int i = 0; i < authNMaterialsTypes.size(); ++i) {
            authNMaterialsTypesStr[i] = XRDSContextUDIMetadata.getTextContent((Element)authNMaterialsTypes.get(i));
        }
        return authNMaterialsTypesStr;
    }

    public final String getAuthNMaterials() throws IdASException {
        if (this.service == null) {
            this.resolve();
        }
        if (this.service == null) {
            throw new IdASException("No service endpoint selected.");
        }
        Vector authNMaterials = this.service.getOtherTagValues("AuthNMaterials");
        if (authNMaterials == null || authNMaterials.size() < 1) {
            return null;
        }
        return (String)authNMaterials.get(0);
    }

    public final Map getConfiguration() throws IdASException {
        Map configuration;
        if (this.service == null) {
            this.resolve();
        }
        if (this.service == null) {
            throw new IdASException("No service endpoint selected.");
        }
        ConfigurationHandler handler = new ConfigurationHandler();
        handler.setSEP(this.service);
        try {
            handler.configure(null);
            configuration = handler.getSettings();
        }
        catch (Exception ex) {
            throw new IdASException("Cannot read configuration from XRDS service endpoint: ", (Throwable)ex);
        }
        return configuration;
    }

    public Service getService() throws IdASException {
        if (this.service == null) {
            this.resolve();
        }
        if (this.service == null) {
            throw new IdASException("No service endpoint selected.");
        }
        return this.service;
    }

    private static String getTextContent(Element element) {
        StringBuffer buffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            buffer.append(node.getNodeValue());
        }
        return buffer.toString();
    }
}

