/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.udi.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.xerces.parsers.DOMParser;
import org.eclipse.higgins.idas.api.IdASException;
import org.openxri.util.DOMUtils;
import org.openxri.xml.XRDS;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XRDSDownloader {
    private static final String ACCEPT_HEADER = "Accept";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String X_XRDS_LOCATION_HEADER = "X-XRDS-Location";
    private static final String XRDS_MIME_TYPE = "application/xrds+xml";
    private static final String HTML_MIME_TYPE = "text/html";
    private static final int MAX_X_XRDS_LOCATION = 15;
    private static final Pattern HTML_META_REGEX = Pattern.compile(".*?<META\\s+HTTP-EQUIV=\"X-XRDS-Location\"\\s+CONTENT=\"(.+?)\"\\s*>.*|.*?<META\\s+CONTENT=\"(.+?)\"\\s+HTTP-EQUIV=\"X-XRDS-Location\"\\s*>.*", 34);

    public static XRDS discoverXRDS(URL url) throws XRDSDownloadException {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new NullTrustManager()}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new NullHostnameVerifier());
        }
        catch (Exception ex) {
            throw new XRDSDownloadException("Cannot set up conntection: " + ex.getMessage(), ex);
        }
        HttpURLConnection.setFollowRedirects(true);
        HttpsURLConnection.setFollowRedirects(true);
        return XRDSDownloader.yadisHead(url);
    }

    private static XRDS yadisHead(URL url) throws XRDSDownloadException {
        return XRDSDownloader.yadisHead(url, true, 1);
    }

    private static XRDS yadisHead(URL url, boolean fallbackToGet, int depth) throws XRDSDownloadException {
        URLConnection connection;
        try {
            connection = url.openConnection();
        }
        catch (IOException ex) {
            throw new XRDSDownloadException("Cannot open connection to " + url.toString(), ex);
        }
        if (!(connection instanceof HttpURLConnection)) {
            throw new XRDSDownloadException("Yadis discovery only works with HTTP(S) URLs.");
        }
        try {
            ((HttpURLConnection)connection).setRequestMethod("HEAD");
            ((HttpURLConnection)connection).addRequestProperty(ACCEPT_HEADER, XRDS_MIME_TYPE);
        }
        catch (Exception ex) {
            throw new XRDSDownloadException("Protocol not supported.", ex);
        }
        if (connection.getHeaderField(X_XRDS_LOCATION_HEADER) != null) {
            URL newUrl;
            try {
                newUrl = new URL(connection.getHeaderField(X_XRDS_LOCATION_HEADER));
            }
            catch (MalformedURLException ex) {
                throw new XRDSDownloadException("URL found in X-XRDS-Location header is malformed.", ex);
            }
            if (newUrl.equals(url)) {
                throw new XRDSDownloadException("URL " + url + " points back to itself. Aborting.");
            }
            if (depth > 15) {
                throw new XRDSDownloadException("Aborting after 15 X-XRDS-Location headers without finding an XRDS document. Aborting.");
            }
            return XRDSDownloader.yadisGet(newUrl, depth + 1);
        }
        String contentType = connection.getHeaderField(CONTENT_TYPE_HEADER);
        if (contentType != null && contentType.toLowerCase().indexOf(XRDS_MIME_TYPE.toLowerCase()) >= 0) {
            return XRDSDownloader.yadisGet(url, depth + 1);
        }
        if (fallbackToGet) {
            return XRDSDownloader.yadisGet(url, depth + 1);
        }
        throw new XRDSDownloadException("Failed to discover any XRDS document from URL: " + url.toString());
    }

    private static XRDS yadisGet(URL url, int depth) throws XRDSDownloadException {
        String document;
        Matcher matcher;
        URL newUrl;
        byte[] body;
        URLConnection connection;
        try {
            connection = url.openConnection();
        }
        catch (IOException ex) {
            throw new XRDSDownloadException("Cannot open connection to " + url.toString(), ex);
        }
        if (!(connection instanceof HttpURLConnection)) {
            throw new XRDSDownloadException("Yadis discovery only works with HTTP(S) URLs.");
        }
        try {
            ((HttpURLConnection)connection).setRequestMethod("GET");
            ((HttpURLConnection)connection).addRequestProperty(ACCEPT_HEADER, XRDS_MIME_TYPE);
        }
        catch (Exception ex) {
            throw new XRDSDownloadException("Protocol not supported.", ex);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            int count;
            InputStream stream = connection.getInputStream();
            byte[] b = new byte[8192];
            while ((count = stream.read(b)) > 0) {
                buffer.write(b, 0, count);
            }
            stream.close();
            body = buffer.toByteArray();
        }
        catch (IOException ex) {
            throw new XRDSDownloadException("Cannot read document", ex);
        }
        String contentType = connection.getHeaderField(CONTENT_TYPE_HEADER);
        if (contentType != null && contentType.toLowerCase().indexOf(XRDS_MIME_TYPE.toLowerCase()) >= 0) {
            XRDS xrds;
            Document document2;
            try {
                DOMParser domParser = DOMUtils.getDOMParser();
                domParser.parse(new InputSource(new ByteArrayInputStream(body)));
                document2 = domParser.getDocument();
            }
            catch (Exception ex) {
                throw new XRDSDownloadException("Cannot parse XML.", ex);
            }
            try {
                xrds = new XRDS(document2.getDocumentElement(), true);
            }
            catch (Exception ex) {
                throw new XRDSDownloadException("Cannot parse XRDS.", ex);
            }
            return xrds;
        }
        if (connection.getHeaderField(X_XRDS_LOCATION_HEADER) != null) {
            try {
                newUrl = new URL(connection.getHeaderField(X_XRDS_LOCATION_HEADER));
            }
            catch (MalformedURLException ex) {
                throw new XRDSDownloadException("URL found in X-XRDS-Location header is malformed.", ex);
            }
            if (newUrl.equals(url)) {
                throw new XRDSDownloadException("URL " + url + " points back to itself. Aborting.");
            }
            if (depth > 15) {
                throw new XRDSDownloadException("Aborting after 15 X-XRDS-Location headers without finding an XRDS document. Aborting.");
            }
            return XRDSDownloader.yadisGet(newUrl, depth + 1);
        }
        contentType = connection.getHeaderField(CONTENT_TYPE_HEADER);
        if (contentType != null && contentType.toLowerCase().indexOf(HTML_MIME_TYPE.toLowerCase()) >= 0 && (matcher = HTML_META_REGEX.matcher(document = new String(body))).matches() && matcher.groupCount() > 0) {
            try {
                newUrl = new URL(matcher.group(1));
            }
            catch (MalformedURLException ex) {
                throw new XRDSDownloadException("URL found in X-XRDS-Location header is malformed.", ex);
            }
            if (newUrl.equals(url)) {
                throw new XRDSDownloadException("URL " + url + " points back to itself. Aborting.");
            }
            if (depth > 15) {
                throw new XRDSDownloadException("Aborting after 15 X-XRDS-Location headers without finding an XRDS document. Aborting.");
            }
            return XRDSDownloader.yadisGet(newUrl, depth + 1);
        }
        throw new XRDSDownloadException("Failed to discover any XRDS document from URL: " + url.toString());
    }

    private static class XRDSDownloadException
    extends IdASException {
        private static final long serialVersionUID = -1810163713862891507L;

        public XRDSDownloadException(String message, Throwable cause) {
            super(message, cause);
        }

        public XRDSDownloadException(String message) {
            super(message);
        }
    }

    private static class NullHostnameVerifier
    implements HostnameVerifier {
        private NullHostnameVerifier() {
        }

        public boolean verify(String rserver, SSLSession sses) {
            return true;
        }
    }

    private static class NullTrustManager
    implements X509TrustManager {
        private NullTrustManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

