/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.udi.util;

import java.io.StringReader;
import org.apache.xerces.parsers.DOMParser;
import org.eclipse.higgins.idas.api.IdASException;
import org.openxri.util.DOMUtils;
import org.openxri.xml.XRDS;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XRDSParser {
    public static XRDS parseXRDS(String string) throws XRDSParseException {
        XRDS xrds;
        Document document;
        try {
            DOMParser domParser = DOMUtils.getDOMParser();
            domParser.parse(new InputSource(new StringReader(string)));
            document = domParser.getDocument();
        }
        catch (Exception ex) {
            throw new XRDSParseException("Cannot parse XML.", ex);
        }
        try {
            xrds = new XRDS(document.getDocumentElement(), true);
        }
        catch (Exception ex) {
            throw new XRDSParseException("Cannot parse XRDS.", ex);
        }
        return xrds;
    }

    private static class XRDSParseException
    extends IdASException {
        private static final long serialVersionUID = 4846637361285803354L;

        public XRDSParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

