/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.iss.cardspace;

import javax.security.auth.callback.CallbackHandler;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.icard.policy.ICardSpacePolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.CardSpacePolicy;
import org.eclipse.higgins.iss.ICardSelectorService;
import org.eclipse.higgins.iss.IICardSelector;
import org.eclipse.higgins.iss.IICardSelectorFactory;
import org.eclipse.higgins.iss.PolicyParseException;
import org.eclipse.higgins.iss.UnsatisfiablePolicyException;
import org.eclipse.higgins.iss.cardspace.CardSpaceSelector;
import org.eclipse.higgins.iss.cardspace.util.CardSpacePolicyHelper;
import org.eclipse.higgins.iss.util.AxiomUtility;
import org.eclipse.higgins.registry.IConfiguration;
import org.eclipse.higgins.registry.IServiceProvider;
import org.eclipse.higgins.registry.RegistryConfigurationException;

public class CardSpaceSelectorFactory
implements IICardSelectorFactory {
    protected static final Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$iss$cardspace$CardSpaceSelectorFactory == null ? (class$org$eclipse$higgins$iss$cardspace$CardSpaceSelectorFactory = CardSpaceSelectorFactory.class$("org.eclipse.higgins.iss.cardspace.CardSpaceSelectorFactory")) : class$org$eclipse$higgins$iss$cardspace$CardSpaceSelectorFactory));
    private static final String ID = "org.eclipse.higgins.iss.cardspace";
    public static final String STS_CONFIGURATION_BASE = "sts.configuration.base";
    private String configuration_base = null;
    protected IConfiguration config = null;
    static /* synthetic */ Class class$org$eclipse$higgins$iss$cardspace$CardSpaceSelectorFactory;

    public IPolicy parsePolicy(String policy) throws PolicyParseException {
        log.info((Object)("policy=\"" + policy + "\""));
        OMElement om = AxiomUtility.getAxiomFromString((String)policy);
        CardSpacePolicy pol = CardSpacePolicyHelper.fromAxiom(om);
        log.trace((Object)("policy=\"" + pol + "\""));
        return pol;
    }

    public IICardSelector getICardSelector(CallbackHandler handler, IPolicy policy) throws UnsatisfiablePolicyException {
        if (policy instanceof ICardSpacePolicy) {
            return new CardSpaceSelector(this.getSTSConfigurationBase(), handler, (ICardSpacePolicy)policy);
        }
        throw new UnsatisfiablePolicyException("Invalid cardspace policy: " + policy);
    }

    public IICardSelector getICardSelector(CallbackHandler handler, String policy) throws PolicyParseException, UnsatisfiablePolicyException {
        IPolicy p = this.parsePolicy(policy);
        return this.getICardSelector(handler, p);
    }

    public String getID() {
        return ID;
    }

    public void setID(String id) throws Exception {
        throw new UnsupportedOperationException();
    }

    public IConfiguration getConfiguration() {
        if (this.config == null) {
            this.initConfiguration();
        }
        return this.config;
    }

    public synchronized void initConfiguration() {
        if (this.config == null) {
            try {
                this.config = ICardSelectorService.getInstance().getConfiguration((IServiceProvider)this);
            }
            catch (RegistryConfigurationException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    public String getSTSConfigurationBase() {
        if (this.configuration_base == null) {
            this.configuration_base = (String)this.getConfiguration().getProperty(STS_CONFIGURATION_BASE);
        }
        return this.configuration_base;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

