/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.iss.cardspace.util;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.configuration.xml.ConfigurationHandler;
import org.eclipse.higgins.iss.ISSException;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.common.Constants;

public class STSHelper2 {
    private static Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$iss$cardspace$util$STSHelper2 == null ? (class$org$eclipse$higgins$iss$cardspace$util$STSHelper2 = STSHelper2.class$("org.eclipse.higgins.iss.cardspace.util.STSHelper2")) : class$org$eclipse$higgins$iss$cardspace$util$STSHelper2));
    private static Map managedStsSettings;
    private static Map personalStsSettings;
    private static IConstants constants;
    private static STSHelper2 singleton;
    static /* synthetic */ Class class$org$eclipse$higgins$iss$cardspace$util$STSHelper2;

    public static STSHelper2 getSingletonInstance() {
        if (singleton == null) {
            STSHelper2.initSingleton();
        }
        return singleton;
    }

    private static synchronized void initSingleton() {
        if (singleton == null) {
            STSHelper2 stsHelper = new STSHelper2();
            try {
                stsHelper.init();
                singleton = stsHelper;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void init() throws Exception {
        String stsConfigurationBase = System.getProperty("org.eclipse.higgins.sts.conf");
        if (null == stsConfigurationBase) {
            throw new ISSException("CardspaceSelector: org.eclipse.higgins.sts.conf System property not found");
        }
        String stsConfigurationPersonalFile = System.getProperty("org.eclipse.higgins.sts.conf.personal.file");
        String stsConfigurationManagedFile = System.getProperty("org.eclipse.higgins.sts.conf.managed.client.file");
        if (stsConfigurationPersonalFile == null) {
            stsConfigurationPersonalFile = "PersonalConfiguration.xml";
        }
        if (stsConfigurationManagedFile == null) {
            stsConfigurationManagedFile = "ClientConfiguration.xml";
        }
        this.init(stsConfigurationBase, stsConfigurationPersonalFile, stsConfigurationManagedFile);
    }

    public void init(String stsCfgBase, String stsPersonalCfgFile, String stsManagedCfgFile) throws Exception {
        Map pSet = this.getConfiguration(stsCfgBase, stsPersonalCfgFile);
        Map mSet = this.getConfiguration(stsCfgBase, stsManagedCfgFile);
        personalStsSettings = pSet;
        managedStsSettings = mSet;
    }

    private Map getConfiguration(String stsConfigurationBase, String stsConfigurationFile) throws Exception {
        ConfigurationHandler configurationHandler = new ConfigurationHandler();
        configurationHandler.setConfigurationBase(stsConfigurationBase);
        configurationHandler.setFileName(stsConfigurationFile);
        if (!configurationHandler.configure(null)) {
            log.error((Object)"Not Initialized!");
            throw new ISSException("CardspaceSelector: cannot initialize configHandler");
        }
        return configurationHandler.getSettings();
    }

    public Map getManagedStsSettings() {
        return managedStsSettings;
    }

    public void setManagedStsSettings(Map managedStsSettings) {
        STSHelper2.managedStsSettings = managedStsSettings;
    }

    public Map getPersonalStsSettings() {
        return personalStsSettings;
    }

    public void setPersonalStsSettings(Map personalStsSettings) {
        STSHelper2.personalStsSettings = personalStsSettings;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        constants = new Constants();
        singleton = null;
    }
}

