/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Bjoern Assmann (IBM Corporation) - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.iss;

import java.util.List;

// tree of depth 2.
// elements of elms are of type UserChoiceTree_OR
public class UserChoiceTree_ANDofORs extends UserChoiceTree {

	public UserChoiceTree_ANDofORs() {
		this.connective = "AND";
	}

	public UserChoiceTree_ANDofORs(List elms) {
		this();
		this.elms = elms;
	}

	public UserChoiceTree_ANDofORs(UCTelm uctElm) {
		this();
		elms.add(new UserChoiceTree_OR(uctElm));
		this.policyIsSatisfied = uctElm.policyIsSatisfied();
	}

	public UserChoiceTree_ANDofORs(UserChoiceTree_OR uct_OR) {
		this();
		elms.add(uct_OR);
		this.policyIsSatisfied = uct_OR.policyIsSatisfied;
	}

	public UserChoiceTree_ANDofORs(UserChoiceTree_AND uct_AND) {
		this();
		this.policyIsSatisfied = uct_AND.policyIsSatisfied;
		// System.out.println( "\n\n policyIsSatisfied: " + this.policyIsSatisfied );
		for (int i = 0; i < uct_AND.elms.size(); i++) {
			UCTelm uct_elm = (UCTelm) uct_AND.elms.get(i);
			elms.add(new UserChoiceTree_OR(uct_elm));
		}
	}

	// always pick first element if each OR branch with first possible credential
	public SelectionANDofORs getDefaultSelection() {
		SelectionANDofORs selection = new SelectionANDofORs();
		for (int i = 0; i < this.elms.size(); i++) {
			UserChoiceTree_OR uct_OR = (UserChoiceTree_OR) this.elms.get(i);
			if (uct_OR.elms.size() > 0) {
				UCTelm uctElm = (UCTelm) uct_OR.elms.get(0);
				if (uctElm.credentialContainers.size() > 0) {
					CredentialContainer credCont = (CredentialContainer) uctElm.credentialContainers.get(0);
					SelectionANDofORsElm elm = new SelectionANDofORsElm(credCont.key, i, 0);
					selection.selectionElms.add(elm);
				}
			}
		}
		return selection;
	}

	// TODO this function was taken from the old data structure UserChoiceList
	// It has to be adapted to the new tree data structure.

	// //this implementation is very simple and inefficient.
	// //If this is to time consuming for exams, we should make
	// //more sophisticated.
	// catch the case that the sum of weights becomes too big.
	// public void computePreselection() {
	//
	// // compute a list of lists of uids that represents all possible
	// // credential choices
	// ArrayList possibleChoices = new ArrayList();
	// possibleChoices.add(new PossibleCredentialChoice());
	// if( elms.size() == 0){
	// //cannoet run preselection on empty user choice list
	// this.bestChoice = null;
	// return;
	// }
	// for (Iterator iter = elms.iterator(); iter.hasNext();) {
	// UCLelm uclelm = (UCLelm) iter.next();
	// // extend possbileChoices by the uclelm.
	// ArrayList possibleChoicesTmp = new ArrayList();
	// if( uclelm.uuids.size() == 0 ){
	// // databse does not saisfy policy
	// this.bestChoice = null;
	// return;
	// }
	// for (int i = 0; i < uclelm.uuids.size(); i++) {
	// for (Iterator iterator = possibleChoices.iterator(); iterator.hasNext();) {
	// PossibleCredentialChoice possibleChoice = (PossibleCredentialChoice) iterator.next();
	// String uuid = (String) uclelm.uuids.get(i);
	// // get weight
	// double weight = 1;
	// try{
	// Certificate cert = (Certificate) uclelm.certs.get(i);
	// UserMetadata useMeta = (UserMetadata) cert.getUserMetadata();
	// weight = useMeta.getWeight();
	// }catch( Exception e ){
	// System.out.println( "Could not access user meta data");
	// }
	// possibleChoicesTmp.add( possibleChoice.extend(uuid, weight) );
	// }
	// }
	// // update possible choices
	// possibleChoices = possibleChoicesTmp;
	//
	// }
	//		
	// System.out.println( "All possibiliets are :");
	// System.out.println( possibleChoices );
	//		
	// // find a globally lightest possible choice
	// PossibleCredentialChoice bestChoice = (PossibleCredentialChoice) possibleChoices.get(0);
	// for (Iterator iter = possibleChoices.iterator(); iter.hasNext();) {
	// PossibleCredentialChoice possChoice = (PossibleCredentialChoice) iter.next();
	// if (possChoice.totalWeight < bestChoice.totalWeight ){
	// bestChoice = possChoice;
	// }
	// }
	//
	// // set the lightest choice.
	// this.bestChoice = bestChoice;
	// }

}
