/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Artem Verkhovets - initial API and implementation
 */
package org.eclipse.higgins.keystore.common.X509;

import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.higgins.keystore.common.utils.Asn1Node;

/**
 * <p>
 * The ASN.1 definition is as follows:
 * <p>
 * 
 * <pre>
 * PolicyInformation ::= SEQUENCE {
 *      policyIdentifier   CertPolicyId,
 *      policyQualifiers   SEQUENCE SIZE (1..MAX) OF PolicyQualifierInfo OPTIONAL }
 * </pre>
 * 
 * <p>
 * 
 * @author Artem Verkhovets
 */
public class PolicyInformation {
	private ObjectIdentifier policyIdentifier;

	private Collection policyQualifiers;

	public ObjectIdentifier getPolicyIdentifier() {
		return policyIdentifier;
	}

	public void setPolicyIdentifier(ObjectIdentifier policyIdentifier) {
		this.policyIdentifier = policyIdentifier;
	}

	public Collection getPolicyQualifiers() {
		return policyQualifiers;
	}

	public void setPolicyQualifiers(Collection policyQualifiers) {
		this.policyQualifiers = policyQualifiers;
	}

	public PolicyInformation(Asn1Node node) {
		try {
			policyQualifiers = new ArrayList();
			parse(node);
		} catch (Exception exc) {

		}
	}

	private void parse(Asn1Node node) throws CertificateParsingException {
		if (!node.getCollection().isEmpty() && node.getCollection().size() >= 1) {
			Asn1Node oidNode = (Asn1Node) node.getCollection().get(0);
			this.policyIdentifier = new ObjectIdentifier(oidNode);
			if (node.getCollection().size() > 1) {
				Asn1Node policyQualifiersNode = (Asn1Node) node.getCollection().get(1);
				if (!policyQualifiersNode.getCollection().isEmpty()) {
					for (Iterator iter = policyQualifiersNode.getCollection().iterator(); iter.hasNext();) {
						this.policyQualifiers.add(new PolicyQualifierInfo((Asn1Node) iter.next()));
					}
				}
			}
		}
	}

	public String toString() {
		StringBuffer stringbuilder = new StringBuffer();
		stringbuilder.append("PolicyInformation: [\n");
		if (policyIdentifier != null) {
			stringbuilder.append("policyIdentifier: ");
			stringbuilder.append(policyIdentifier.toString());
		}
		if (policyQualifiers != null) {
			stringbuilder.append("\n   policyQualifiers: ");
			PolicyQualifierInfo policyQualifier;
			for (Iterator iterator = policyQualifiers.iterator(); iterator.hasNext(); stringbuilder.append(policyQualifier.toString()))
				policyQualifier = (PolicyQualifierInfo) iterator.next();
		}
		stringbuilder.append("]\n");
		return stringbuilder.toString();
	}

}
