package org.eclipse.higgins.keystore.common.impl;

import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;

import javax.security.auth.callback.CallbackHandler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.keystore.common.KeyStoreService;
import org.eclipse.higgins.keystore.common.X509.X509HigginsCertificate;
import org.eclipse.higgins.keystore.common.entity.X509CertificateEntity;
import org.eclipse.higgins.keystore.common.utils.ConvertHelper;
import org.eclipse.higgins.registry.IConfiguration;

public final class KeyStoreServiceImp extends KeyStoreService {

	private static final HashMap certMap = new HashMap();
	
	private CertStore defaultTrustCertStore = null;

	private String id = "org.eclipse.higgins.keystore.provider.default";

	private Log log = LogFactory.getLog(KeyStoreServiceImp.class);

	/**
	 * 
	 */
	public KeyStoreServiceImp() {
		super();
		initialize();
	}

	public CertStore addToCertStore(CallbackHandler handler,CertStore certStore) throws CertificateException, CertStoreException {
		// TODO Auto-generated method stub
		return null;
	}

	public CertStore addToCertStore(CallbackHandler handler,X509Certificate[] certificates) throws CertificateException, CertStoreException {
		// TODO Auto-generated method stub
		return null;
	}

	public CertStore deleteFromCertStore(CallbackHandler handler,CertStore certStore) throws CertificateException, CertStoreException {
		// TODO Auto-generated method stub
		return null;
	}

	public CertStore deleteFromCertStore(CallbackHandler handler,X509Certificate[] certificates) throws CertificateException, CertStoreException {
		// TODO Auto-generated method stub
		return null;
	}

	public CertStore getCertStore(CallbackHandler handler) throws CertificateException, CertStoreException {
		return getDefaultTrustCertStore(handler);
	}

	public CertStore getDefaultTrustCertStore(CallbackHandler handler) {
		return defaultTrustCertStore;
	}

	public IConfiguration getConfiguration() {
		// TODO Auto-generated method stub
		return null;
	}

	public String getID() {
		return id;
	}

	public void setID(String id) throws Exception {
		this.id = id;
	}

	public X509Certificate[] getValidateCertificateChain(CallbackHandler handler,X509Certificate[] certPath, URI uri) throws CertificateException, CertStoreException {

		return getValidateCertificateChain(handler,certPath, uri,null);
	}

	public X509Certificate[] getValidateCertificateChain(CallbackHandler handler,X509Certificate[] certPath, URI uri, CertStore certStore) throws CertificateException, CertStoreException {
		CertStore tempCertStore = KeyStoreService.joinCertStore(getCertStore(handler), certStore);
		return super.getValidateCertificateChain(handler,certPath, uri, tempCertStore);
	}
	
	public X509Certificate [] getNormalizedCertificateChain(CallbackHandler handler,X509Certificate [] certPath, CertStore certStore) throws CertificateException, CertStoreException
	{
		CertStore tempCertStore = KeyStoreService.joinCertStore(getCertStore(handler), certStore);
		return super.getNormalizedCertificateChain(certPath,tempCertStore);
	}

	public boolean extendendValidationCertificateChain(CallbackHandler handler,X509Certificate[] certChain,URI uri) {
		return extendendValidationCertificateChain(handler,certChain, uri, null);
	}
	
	public boolean extendendValidationCertificateChain(CallbackHandler handler,X509Certificate[] certChain,URI uri, CertStore certStore) {
		try {
			CertStore tempCertStore = KeyStoreService.joinCertStore(getCertStore(handler), certStore);
			return super.extendendValidationCertificateChain(handler,certChain, uri, tempCertStore);
		} catch (Exception e) {
			log.error(e, e);
		}
		return false;
	}

	public boolean validateCertificateChain(CallbackHandler handler,X509Certificate[] certChain, URI uri) {
		return validateCertificateChain(handler,certChain, uri, null);
	}

	public boolean validateCertificateChain(CallbackHandler handler,X509Certificate[] certChain, URI uri, CertStore certStore) {

		try {
			CertStore tempCertStore = KeyStoreService.joinCertStore(getCertStore(handler), certStore);
			return super.validateCertificateChain(handler,certChain, uri, tempCertStore);
		} catch (Exception e) {
			log.error(e, e);
		}
		return false;
	}

	private void initialize() {
		KeyStore keystore = null;
		String password = "changeit";
		Collection collCertificates = new ArrayList();
		try {
			String filename = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
			FileInputStream is = new FileInputStream(filename);
			keystore = KeyStore.getInstance(KeyStore.getDefaultType());
			keystore.load(is, password.toCharArray());

			Enumeration enumCertificates = keystore.aliases();
			while (enumCertificates.hasMoreElements()) {
				String strAlias = (String) enumCertificates.nextElement();
				Certificate cert = keystore.getCertificate(strAlias);
				collCertificates.add(cert);
			}
		} catch (Exception e) {
			log.error(e, e);
		}

		try {
			String filename = System.getProperty("javax.net.ssl.trustStore");
			password = (System.getProperty("javax.net.ssl.trustStorePassword") != null) ? System.getProperty("javax.net.ssl.trustStorePassword") : password;

			FileInputStream is = new FileInputStream(filename);
			keystore = KeyStore.getInstance(KeyStore.getDefaultType());
			keystore.load(is, password.toCharArray());

			Enumeration enumCertificates = keystore.aliases();
			while (enumCertificates.hasMoreElements()) {
				String strAlias = (String) enumCertificates.nextElement();
				Certificate cert = keystore.getCertificate(strAlias);
				collCertificates.add(cert);
			}
		} catch (Exception e) {
			log.error(e, e);
		}

		CollectionCertStoreParameters collCSP = new CollectionCertStoreParameters(collCertificates);
		try {
			defaultTrustCertStore = CertStore.getInstance("Collection", collCSP);
		} catch (InvalidAlgorithmParameterException e) {
			log.error(e, e);
		} catch (NoSuchAlgorithmException e) {
			log.error(e, e);
		}
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.higgins.certstore.api.ICertificateStore#getCertChain()
	 */
	public X509Certificate [] getCertChainFromStore(final String id) {
		if (certMap.containsKey(id))
		{
			try
			{
				ArrayList certPath=new ArrayList();
				X509CertificateEntity entity = (X509CertificateEntity) certMap.get(id);
				while (entity!=null)
				{
					X509Certificate[] certs=getCertificatesFromByteArray(entity.getEncodedCertificate());
					if (certs!=null && certs.length>0)
						certPath.add(new X509HigginsCertificate(certs[0]));
					entity=entity.getSignedBy();
				}				
				return (X509Certificate[])certPath.toArray(new X509Certificate[certPath.size()]);
			} catch (CertificateException e)
			{
				log.error(e, e);
			}
			return null;
		}
		else return null;
	}
	
	/**
	 * @param certificateEntityList
	 * @param force
	 * @throws CertificateStoreException
	 */
	private void modifyCertChain(final X509CertificateEntity certificateEntity, final boolean force) throws CertStoreException {
		try {
			if (force || !certMap.containsKey(certificateEntity.getId())) {
				certMap.put(certificateEntity.getId(), certificateEntity);
				log.debug("put certificate id:" + certificateEntity.getId());
			}
		} catch (final Exception e) {
			//log.error(e, e);
			throw new CertStoreException(e);
		}
	}
	
	/**
	 * @param certificateEntityList
	 * @param force
	 * @throws CertificateStoreException
	 */
	private void modifyCertChain(final X509Certificate [] certificatePath, final boolean force) throws CertStoreException {
		try {
			modifyCertChain(ConvertHelper.convertCertChainToEntity(certificatePath),force);
		} catch (final Exception e) {
			//log.error(e, e);
			throw new CertStoreException(e);
		}
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.higgins.certstore.api.ICertificateStore#putCertChain()
	 */
	public void putCertChain(final X509Certificate [] certificatePath) throws CertStoreException {
		modifyCertChain(certificatePath, false);
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.higgins.certstore.api.ICertificateStore#updateCertChain()
	 */
	public void updateCertChain(final X509Certificate [] certificatePath) throws CertStoreException {
		modifyCertChain(certificatePath, true);
	}
}
