/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Artem Verkhovets - initial API and implementation
 */
package org.eclipse.higgins.keystore.common.X509;

import java.security.cert.CertificateParsingException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;

import org.eclipse.higgins.keystore.common.utils.Asn1Node;

public class URIName {
	private URI uri;

	public URIName(Asn1Node node) throws CertificateParsingException {
		try {
			initialize(node.getValueAsIA5String());
		} catch (UnsupportedEncodingException e) {
			throw (CertificateParsingException) (new CertificateParsingException(e.toString())).initCause(e);
		}

	}

	public URIName(String s) throws CertificateParsingException {
		initialize(s);
	}

	private void initialize(String s) throws CertificateParsingException {
		try {
			uri = new URI(s);
		} catch (URISyntaxException urisyntaxexception) {
			throw (CertificateParsingException) (new CertificateParsingException(urisyntaxexception.toString())).initCause(urisyntaxexception);
		}
	}

	public String toString() {
		return (new StringBuffer()).append("URIName: ").append(uri.toString()).toString();
	}

	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!(obj instanceof URIName)) {
			return false;
		} else {
			URIName uriname = (URIName) obj;
			return uri.equals(uriname.getURI());
		}
	}

	public URI getURI() {
		return uri;
	}

	public int hashCode() {
		return uri.hashCode();
	}
}
