package org.eclipse.higgins.keystore.registry;

import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.keystore.IKeyStoreService;
import org.eclipse.higgins.keystore.common.impl.KeyStoreServiceImp;
import org.eclipse.higgins.registry.HigginsRegistry;
import org.eclipse.higgins.registry.IConfiguration;
import org.eclipse.higgins.registry.IRegistryExtension;
import org.eclipse.higgins.registry.IServiceProvider;
import org.eclipse.higgins.registry.PropertiesConfigurationFactory;
import org.eclipse.higgins.registry.RegistryConfigurationException;
import org.eclipse.higgins.registry.SecurityRegistryExtension;
import org.eclipse.higgins.registry.IIORegistryExtension;

public class KeyStoreRegistry extends HigginsRegistry {
	private Log log = LogFactory.getLog(KeyStoreRegistry.class);	
	private static KeyStoreRegistry instance = null;
	protected static PropertiesConfigurationFactory configFactory = new PropertiesConfigurationFactory(".security");

	/**
	 * Set up the valid service provider categories and automatically register
	 * all available service providers.
	 * 
	 * <p>
	 * The constructor is protected in order to prevent creation of additional
	 * instances.
	 */
	protected KeyStoreRegistry() {
		super(IKeyStoreService.class);
		initialize();
	}

	/**
	 * @param configPath
	 * @throws RegistryConfigurationException 
	 */
	public KeyStoreRegistry(String configPath) throws RegistryConfigurationException {
		super(IKeyStoreService.class);
		configFactory.setRootHigginsConfigPath(configPath);
		initialize();
	}
	
	private void initialize() {
		addExtension(new IIORegistryExtension(IKeyStoreService.class));
		addExtension(new SecurityRegistryExtension(IKeyStoreService.class));
		try {
			Class c = Class.forName("org.eclipse.higgins.keystore.registry.plugin.KeyStoreRegistryExtension");
			IRegistryExtension e = (IRegistryExtension) c.newInstance();
			addExtension(e);
		} catch (ClassNotFoundException e) {
		} catch (Throwable e) {
			log.error(e);
		}
		loadProviders();
	
		try {
			if (providers.size() > 1 ) {
				log.warn("There are more than one Security providers! " + providers.keySet().toString());
			}
			//if no user profile service provider found, adding default implementation
			if (providers.size() == 0) {
				add(new KeyStoreServiceImp());
			}
		} catch (Exception e) {
			log.error(e);
		}
			
	}

	public synchronized static KeyStoreRegistry getInstance() {
		if (instance == null) {
			instance = new KeyStoreRegistry();
		}
		return instance;
	}
	
	public IKeyStoreService getSecurityService() {
		Iterator it = instance.getServiceProviders();
		//there is always only user profile service provider
		if (it.hasNext()) {
			return (IKeyStoreService) it.next();
		}
		return null;
	}

	public IConfiguration getConfiguration(IServiceProvider provider) throws RegistryConfigurationException {
		return configFactory.getConfigurqation(provider.getID());
	}

}

