/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.keystore.registry;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.keystore.IKeyStoreService;
import org.eclipse.higgins.keystore.common.impl.KeyStoreServiceImp;
import org.eclipse.higgins.registry.HigginsRegistry;
import org.eclipse.higgins.registry.IConfiguration;
import org.eclipse.higgins.registry.IIORegistryExtension;
import org.eclipse.higgins.registry.IRegistryExtension;
import org.eclipse.higgins.registry.IServiceProvider;
import org.eclipse.higgins.registry.PropertiesConfigurationFactory;
import org.eclipse.higgins.registry.RegistryConfigurationException;
import org.eclipse.higgins.registry.SecurityRegistryExtension;

public class KeyStoreRegistry
extends HigginsRegistry {
    private Log log;
    private static KeyStoreRegistry instance = null;
    protected static PropertiesConfigurationFactory configFactory = new PropertiesConfigurationFactory(".security");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected KeyStoreRegistry() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.higgins.keystore.IKeyStoreService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.higgins.keystore.registry.KeyStoreRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz2);
        this.initialize();
    }

    public KeyStoreRegistry(String configPath) throws RegistryConfigurationException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.higgins.keystore.IKeyStoreService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.higgins.keystore.registry.KeyStoreRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz2);
        configFactory.setRootHigginsConfigPath(configPath);
        this.initialize();
    }

    private void initialize() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.higgins.keystore.IKeyStoreService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addExtension((IRegistryExtension)new IIORegistryExtension((Class)clazz));
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.higgins.keystore.IKeyStoreService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addExtension((IRegistryExtension)new SecurityRegistryExtension((Class)clazz2));
        try {
            Class<?> c = Class.forName("org.eclipse.higgins.keystore.registry.plugin.KeyStoreRegistryExtension");
            IRegistryExtension e = (IRegistryExtension)c.newInstance();
            this.addExtension(e);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Throwable e) {
            this.log.error((Object)e);
        }
        this.loadProviders();
        try {
            if (this.providers.size() > 1) {
                this.log.warn((Object)("There are more than one Security providers! " + this.providers.keySet().toString()));
            }
            if (this.providers.size() == 0) {
                this.add((IServiceProvider)new KeyStoreServiceImp());
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
    }

    public static synchronized KeyStoreRegistry getInstance() {
        if (instance == null) {
            instance = new KeyStoreRegistry();
        }
        return instance;
    }

    public IKeyStoreService getSecurityService() {
        Iterator it = instance.getServiceProviders();
        if (it.hasNext()) {
            return (IKeyStoreService)it.next();
        }
        return null;
    }

    public IConfiguration getConfiguration(IServiceProvider provider) throws RegistryConfigurationException {
        return configFactory.getConfigurqation(provider.getID());
    }
}

