/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.registry.IConfiguration;
import org.eclipse.higgins.registry.IRegistryExtension;
import org.eclipse.higgins.registry.IServiceProvider;
import org.eclipse.higgins.registry.RegistryConfigurationException;

public abstract class HigginsRegistry {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$registry$HigginsRegistry == null ? (class$org$eclipse$higgins$registry$HigginsRegistry = HigginsRegistry.class$("org.eclipse.higgins.registry.HigginsRegistry")) : class$org$eclipse$higgins$registry$HigginsRegistry));
    protected List extensions = new ArrayList();
    protected HashMap providers = new HashMap();
    protected Class type;
    static /* synthetic */ Class class$org$eclipse$higgins$registry$HigginsRegistry;

    public HigginsRegistry(Class type) {
        this.type = type;
    }

    public void addExtension(IRegistryExtension ext) {
        if (ext != null && !this.extensions.contains(ext)) {
            this.extensions.add(ext);
        }
    }

    public void loadProviders() {
        for (int i = 0; i < this.extensions.size(); ++i) {
            IRegistryExtension e = (IRegistryExtension)this.extensions.get(i);
            this.loadProviders(e);
        }
    }

    protected void loadProviders(IRegistryExtension e) {
        Iterator itr = e.getServiceProviders();
        while (itr.hasNext()) {
            Object o = itr.next();
            this.add(o);
        }
    }

    public synchronized Iterator getServiceProviders() {
        return this.providers.values().iterator();
    }

    public synchronized Object getServiceProvider(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument \"id\" can't be null.");
        }
        return this.providers.get(id);
    }

    protected synchronized void add(Object provider) {
        if (provider == null) {
            new IllegalArgumentException("Argument \"provider\" can't be null.");
        }
        if (this.type.isInstance(provider)) {
            if (provider instanceof IServiceProvider) {
                this.add((IServiceProvider)provider);
            } else {
                String id = provider.getClass().getName();
                if (this.providers.get(id) == null) {
                    this.providers.put(id, provider);
                }
            }
        } else {
            this.log.error((Object)(this.getClass().getName() + "::add(Object provider) provider=\"" + provider + "\" is not instance of \"" + this.type.getName() + "\""));
        }
    }

    protected synchronized void add(IServiceProvider provider) {
        String id = provider.getID();
        if (id == null) {
            new IllegalArgumentException("Provider's ID can't be null.").printStackTrace();
            return;
        }
        if (this.providers.get(id) == null) {
            this.providers.put(id, provider);
        } else {
            this.log.error((Object)("Can not add provider with Id = " + id + ". Provider with such Id already exists in registry."));
        }
    }

    public synchronized void remove(IServiceProvider provider) {
        String id;
        if (provider == null) {
            new IllegalArgumentException("Argument \"provider\" can't be null.");
        }
        if ((id = provider.getID()) == null) {
            new IllegalArgumentException("Provider's ID can't be null.");
        }
        this.providers.remove(id);
    }

    public Class getProviderType() {
        return this.type;
    }

    public abstract IConfiguration getConfiguration(IServiceProvider var1) throws RegistryConfigurationException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

