/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.registry.IConfiguration;
import org.eclipse.higgins.registry.RegistryConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PropertiesConfiguration
implements IConfiguration {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$registry$PropertiesConfiguration == null ? (class$org$eclipse$higgins$registry$PropertiesConfiguration = PropertiesConfiguration.class$("org.eclipse.higgins.registry.PropertiesConfiguration")) : class$org$eclipse$higgins$registry$PropertiesConfiguration));
    private HashMap defaults = null;
    private HashMap properties = null;
    private String fileName = null;
    private String providerId = null;
    static /* synthetic */ Class class$org$eclipse$higgins$registry$PropertiesConfiguration;

    public PropertiesConfiguration(String providerId, String providerConfigFile) throws RegistryConfigurationException {
        this.providerId = providerId;
        this.fileName = providerConfigFile;
        this.loadDefaults();
        this.loadProperties();
    }

    /*
     * Unable to fully structure code
     */
    private void loadProperties() throws RegistryConfigurationException {
        block11: {
            this.properties = new HashMap<K, V>();
            this.log.info((Object)("config=\"" + this.fileName + "\""));
            is = null;
            try {
                block10: {
                    f = new File(this.fileName);
                    if (f.exists() && f.isFile()) {
                        is = new FileInputStream(f);
                        this.properties.putAll(this.loadProperties(is));
                        break block10;
                    }
                    this.log.warn((Object)("Configuration file not found for provider " + this.providerId));
                }
                var4_4 = null;
                ** if (is == null) goto lbl-1000
            }
            catch (Throwable var3_8) {
                var4_5 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        this.log.error((Object)e, (Throwable)e);
                    }
                }
                throw var3_8;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    is.close();
                }
                catch (Exception e) {
                    this.log.error((Object)e, (Throwable)e);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block11;
                catch (Exception e) {
                    this.log.error((Object)e, (Throwable)e);
                    throw new RegistryConfigurationException(e);
                }
            }
        }
        this.log.info((Object)("properties=\"" + this.properties + "\""));
    }

    /*
     * Unable to fully structure code
     */
    private void loadDefaults() throws RegistryConfigurationException {
        block10: {
            this.defaults = new HashMap<K, V>();
            is = null;
            try {
                block9: {
                    is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.providerId + ".ini");
                    if (is == null) break block9;
                    this.defaults.putAll(this.loadProperties(is));
                }
                var4_2 = null;
                ** if (is == null) goto lbl-1000
            }
            catch (Throwable var3_7) {
                var4_3 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        this.log.error((Object)e, (Throwable)e);
                    }
                }
                throw var3_7;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    is.close();
                }
                catch (IOException e) {
                    this.log.error((Object)e, (Throwable)e);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block10;
                catch (Exception e) {
                    this.log.error((Object)e, (Throwable)e);
                    throw new RegistryConfigurationException(e);
                }
            }
        }
        this.log.info((Object)("defaults=\"" + this.defaults + "\""));
    }

    private HashMap loadProperties(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document doc = null;
        DocumentBuilder db = dbf.newDocumentBuilder();
        doc = db.parse(new InputSource(is));
        Element root = doc.getDocumentElement();
        return this.loadProperties(root);
    }

    private HashMap loadProperties(Element e) {
        HashMap<String, String> props = new HashMap<String, String>();
        NodeList nl = e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element el;
            String name;
            Node node = nl.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals("parameter") || (name = (el = (Element)node).getAttribute("name")).length() <= 0) continue;
            String value = el.getAttribute("value");
            props.put(name, value);
        }
        return props;
    }

    public Iterator getPropertyNames() {
        HashSet set = new HashSet();
        set.addAll(this.defaults.keySet());
        set.addAll(this.properties.keySet());
        return set.iterator();
    }

    public Object getProperty(String key) {
        if (this.properties.containsKey(key)) {
            return this.properties.get(key);
        }
        if (this.defaults.containsKey(key)) {
            return this.defaults.get(key);
        }
        return null;
    }

    public Object getProperty(String key, Object defaultValue) {
        Object prop = this.getProperty(key);
        if (prop != null) {
            return prop;
        }
        return defaultValue;
    }

    public void setProperty(String key, Object property) throws RegistryConfigurationException {
        this.properties.put(key, property);
    }

    public void save() {
        throw new UnsupportedOperationException();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

