/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.registry;

import java.io.File;
import org.eclipse.higgins.registry.PropertiesConfiguration;
import org.eclipse.higgins.registry.RegistryConfigurationException;

public class PropertiesConfigurationFactory {
    protected String rootHigginsConfigPath = System.getProperty("user.home") + File.separator + ".higgins";
    private String registrySubFolder = null;

    public PropertiesConfigurationFactory(String registrySubFolder) {
        this.registrySubFolder = registrySubFolder;
    }

    public PropertiesConfigurationFactory(String rootHigginsConfigPath, String registrySubFolder) {
        this.registrySubFolder = registrySubFolder;
        this.rootHigginsConfigPath = rootHigginsConfigPath;
    }

    public PropertiesConfiguration getConfigurqation(String providerId) throws RegistryConfigurationException {
        return new PropertiesConfiguration(providerId, this.getConfigFileName(providerId));
    }

    public void setRootHigginsConfigPath(String path) throws RegistryConfigurationException {
        File f = new File(path);
        if (!f.exists() || !f.isDirectory()) {
            throw new RegistryConfigurationException("File directory does not exist : " + path);
        }
        this.rootHigginsConfigPath = path;
    }

    public String getConfigFileName(String providerId) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.rootHigginsConfigPath);
        sb.append(File.separator);
        if (this.registrySubFolder != null) {
            sb.append(this.registrySubFolder);
            sb.append(File.separator);
        }
        sb.append(providerId);
        sb.append(".ini");
        return sb.toString();
    }
}

