/*******************************************************************************
 * Copyright (c) 2009 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.registry;

import java.security.ProviderException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;

/**
 * RegistryExtension based on higgins configuration.
 * 
 */
public class HCRegistryExtension implements IRegistryExtension, IConfigurableComponent {
	private static Log log = LogFactory.getLog(HCRegistryExtension.class);
	public static final String PROVIDERS_LIST_SETTING_NAME = "RegistryProvidersList";
	private boolean isInitialised = false;
	private HashSet providers = new HashSet();

	public HCRegistryExtension() {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.higgins.registry.IRegistryExtension#getServiceProviders()
	 */
	public Iterator getServiceProviders() {
		if (!isInitialised) {
			log.error(HCRegistryExtension.class.getName() + " was not configured.");
		}
		return providers.iterator();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.higgins.configuration.api.IConfigurableComponent#configure
	 * (java.util.Map, java.lang.String, java.util.Map,
	 * org.eclipse.higgins.configuration.api.ISettingDescriptor,
	 * org.eclipse.higgins.configuration.api.ISettingDescriptor)
	 */
	public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings,
			ISettingDescriptor componentDescriptor, ISettingDescriptor globalDescriptor) throws Exception {
		isInitialised = false;
		HashSet newProviders = new HashSet();
		if (mapComponentSettings.containsKey(PROVIDERS_LIST_SETTING_NAME)) {
			List providers = (List) mapComponentSettings.get(PROVIDERS_LIST_SETTING_NAME);
			for (int i = 0, size = providers.size(); i < size; i++) {
				String providerName = (String) providers.get(i);
				if (mapGlobalSettings.containsKey(providerName)) {
					Object obj = mapGlobalSettings.get(providerName);
					if (obj instanceof IServiceProvider) {
						newProviders.add(obj);
					} else {
						throw new ProviderException("Setting " + providerName + " is not an instance of "
								+ IServiceProvider.class.getName());
					}
				} else {
					throw new ProviderException("Provider not found in global settings : " + providerName);
				}

			}
		} else {
			throw new RegistryException(PROVIDERS_LIST_SETTING_NAME + " setting not found.");
		}
		providers = newProviders;
		isInitialised = true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seeorg.eclipse.higgins.configuration.api.IConfigurableComponent#
	 * getComponentDescriptor()
	 */
	public ISettingDescriptor getComponentDescriptor() {
		return null;
	}

}
