/*******************************************************************************
 * Copyright (c) 2009 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.registry;

import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.configuration.api.IConfigurableComponentFactory;

public class HCRegistryExtensionFactory implements IConfigurableComponentFactory {

	private HCRegistryExtension singleton = null;

	/*
	 * (non-Javadoc)
	 * 
	 * @seeorg.eclipse.higgins.configuration.api.IConfigurableComponentFactory#
	 * getNewInstance()
	 */
	public IConfigurableComponent getNewInstance() {
		return new HCRegistryExtension();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seeorg.eclipse.higgins.configuration.api.IConfigurableComponentFactory#
	 * getSingletonInstance()
	 */
	public IConfigurableComponent getSingletonInstance() {
		if (singleton == null) {
			initSingleton();
		}
		return singleton;
	}

	/**
	 * 
	 */
	private synchronized void initSingleton() {
		if (singleton == null) {
			singleton = new HCRegistryExtension();
		}
	}

}
