/*******************************************************************************
 * Copyright (c) 2006-2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.registry;


/**
 * Base interface to be registable in the Higgins Regisrty.
 */
public interface IServiceProvider {

	/**
	 * Returns the id of this service provider.
	 * 
	 * @return a non-<code>null</code> <code>String</code> containing the
	 *         identifier of the service.
	 */
	public String getID();

	/**
	 * Sets the id of this service provider. In most cases the id of the service
	 * provider is unmodifiable. This method should only be used by
	 * {@link IRegistryExtension}s to initialize service provider instance when
	 * <code>getID</code> returns <code>null</code>.
	 * 
	 * @param id -
	 *            the service provider id
	 * @throws Exception
	 *             if id of this service provider can't be modified.
	 */
	public void setID(String id) throws Exception;

	/**
	 * Returns configuration of this service provider. When service provider is
	 * registered in the {@link HigginsRegistry} returned configuration is used
	 * to load service's configuration.
	 * 
	 * @return the configuration of this service provider.
	 */
	public IConfiguration getConfiguration();

}