/*******************************************************************************
 * Copyright (c) 2009 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.registry;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MapConfiguraton implements IConfiguration {
	private Map config;

	/**
	 * @param config
	 */
	public MapConfiguraton(Map config) {
		this.config = new HashMap(config);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.higgins.registry.IConfiguration#getProperty(java.lang.String)
	 */
	public Object getProperty(String key) {
		return config.get(key);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.higgins.registry.IConfiguration#getProperty(java.lang.String,
	 * java.lang.Object)
	 */
	public Object getProperty(String key, Object defaultValue) {
		Object obj = config.get(key);
		return (obj != null) ? obj : defaultValue;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.registry.IConfiguration#getPropertyNames()
	 */
	public Iterator getPropertyNames() {
		// TODO Auto-generated method stub
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.registry.IConfiguration#save()
	 */
	public void save() throws RegistryConfigurationException {
		throw new RegistryConfigurationException("Unsupported operation.");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.higgins.registry.IConfiguration#setProperty(java.lang.String,
	 * java.lang.Object)
	 */
	public void setProperty(String key, Object property) throws RegistryConfigurationException {
		config.put(key, property);
	}

}
