/*******************************************************************************
 * Copyright (c) 2009 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.registry;

import java.io.File;

public class PropertiesConfigurationFactory {

	protected String rootHigginsConfigPath = System.getProperty("user.home") + File.separator + ".higgins";

	private String registrySubFolder = null;

	public PropertiesConfigurationFactory(String registrySubFolder) {
		this.registrySubFolder = registrySubFolder;
	}

	public PropertiesConfigurationFactory(String rootHigginsConfigPath, String registrySubFolder) {
		this.registrySubFolder = registrySubFolder;
		this.rootHigginsConfigPath = rootHigginsConfigPath;
	}

	public PropertiesConfiguration getConfigurqation(String providerId) throws RegistryConfigurationException {
		return new PropertiesConfiguration(providerId, getConfigFileName(providerId));
	}

	public void setRootHigginsConfigPath(String path) throws RegistryConfigurationException {
		File f = new File(path);
		if (!f.exists() || !f.isDirectory())
			throw new RegistryConfigurationException("File directory does not exist : " + path);
		rootHigginsConfigPath = path;
	}

	public String getConfigFileName(String providerId) {
		StringBuffer sb = new StringBuffer();
		sb.append(rootHigginsConfigPath);
		sb.append(File.separator);
		if (registrySubFolder != null) {
			sb.append(registrySubFolder);
			sb.append(File.separator);
		}
		sb.append(providerId);
		sb.append(".ini");
		return sb.toString();
	}

}
