/*******************************************************************************
 * Copyright (c) 2006-2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.registry;

import java.util.Iterator;

/**
 * Higgins Registry uses registry extensions to lookup for available service
 * providers.
 * 
 * @see org.eclipse.higgins.registry.HigginsRegistry
 * @see org.eclipse.higgins.registry.IServiceProvider
 * 
 * @param <E>
 *            the service provider type
 */
public interface IRegistryExtension {
	/**
	 * Searches for implementations of a particular service provider type.
	 * Instantiates and returns all available service providers of appropriate
	 * type <code>E</code>>.
	 * 
	 * @return an {@link Iterator} set of {@link IServiceProvider}s
	 */
	public Iterator getServiceProviders();
}