/*******************************************************************************
 * Copyright (c) 2006-2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.registry.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.higgins.registry.IRegistryExtension;
import org.eclipse.higgins.registry.IServiceProvider;
import org.eclipse.higgins.registry.RegistryException;

/**
 * This implementation of
 * {@link org.eclipse.higgins.registry.IRegistryExtension} uses Eclipse
 * extension point mechanism to lookup for available service providers.
 * 
 * @see org.eclipse.higgins.registry.IRegistryExtension
 * 
 * @param <E>
 *            the service provider type to search for
 */
public abstract class PluginRegistryExtension implements IRegistryExtension {
	protected String xpid = null;

	public PluginRegistryExtension(String xpid) {
		this.xpid = xpid;
	}

	/**
	 * Create an instance of type <E> using provided <code>extension</code>
	 * and <code>element</code>.
	 * 
	 * @param extension
	 * @param element
	 * @return
	 * @throws RegistryException
	 */
	public abstract IServiceProvider createProvider(IExtension extension, IConfigurationElement element) throws RegistryException;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.registry.plugin.IHigginsRegistryExtension#getServiceProviders()
	 */
	public Iterator getServiceProviders() {
		List list = new ArrayList();
		try {
			IExtensionRegistry r = Platform.getExtensionRegistry();
			if (r == null) {
				return list.iterator();
			}
			IExtensionPoint extensionPoint = r.getExtensionPoint(xpid);
			if (extensionPoint == null)
				return list.iterator();
			IExtension[] extensions = extensionPoint.getExtensions();

			// For each extension ...
			for (int i = 0; i < extensions.length; i++) {
				IExtension extension = extensions[i];
				IConfigurationElement[] elements = extension.getConfigurationElements();

				// For each member of the extension ...
				for (int j = 0; j < elements.length; j++) {
					IConfigurationElement element = elements[j];
					IServiceProvider p = null;
					try {
						p = createProvider(extension, element);
						if (p != null) {
							list.add(p);
						}
					} catch (RegistryException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return list.iterator();
	}
}
