/*******************************************************************************
 * Copyright (c) 2006-2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.registry.utils;

import java.io.File;

public class ConfigUtil {
	public static String resolvePath(String path) {
		String res = null;
		if (path.startsWith("@")) {
			int pos = path.indexOf("\\");
			if (pos == -1) {
				pos = path.indexOf("/");
			}
			if (pos != -1) {
				String var = path.substring(1, pos);
				String val = System.getProperty(var);
				res = new File(val + path.substring(pos)).getAbsolutePath();
			}
		} else if (path.startsWith("$")) {
			int pos = path.indexOf("\\");
			if (pos == -1) {
				pos = path.indexOf("/");
			}
			if (pos != -1) {
				String var = path.substring(1, pos);
				String val = System.getenv(var);
				res = new File(val + path.substring(pos)).getAbsolutePath();
			}
		} else {
			res = new File(path).getAbsolutePath();
			res = path;
		}
		return res;
	}

	public static String getFilePath(String file, String path) {
		String res = null;
		if (file != null) {
			res = resolvePath(file);
			if (res != null) {
				File f = new File(res);
				if (!f.isAbsolute() && path != null) {
					res = path + File.separator + res;
				}
				res = new File(res).getAbsolutePath();
			}
		}
		return res;
	}
}
