/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Bruce Rich (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.rp.icard.token.identity;

import java.io.Serializable;

public class Attribute implements Serializable {
	
	private static final long serialVersionUID = 1L;
	private String name;
	private String namespace;
	private String value;
	
	/**
	 * 
	 * @param name
	 * @param namespace
	 * @param value
	 */
	public Attribute(String name, String namespace, String value) {
		this.name = name;
		this.namespace = namespace;
		this.value = value;
	}
	
	public String getName() {
		return name;
	}
	
	public String getNamespace() {
		return namespace;
	}
	
	public String getValue() {
		return value;
	}
	
	public String getFQN() {
		StringBuffer sb = new StringBuffer(namespace);
		if (!namespace.endsWith("/"))
			sb.append("/");
		sb.append(name);
		return sb.toString();
	}
	
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append("name = ").append(name).append(", namespace = ").append(namespace);
		sb.append(", value = ").append(value);
		return sb.toString();
	}
	
	protected Attribute(String name, String Namespace) {
		this.name = name;
		this.namespace = Namespace;
	}
}
