/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Suresh Chari (IBM Corporation) - initial implementation
 *******************************************************************************/ 
package org.eclipse.higgins.rp;

import java.util.Map;

/**
 * 
 * The top level interface which defines the Relying Party interface. This is
 * essentially a factory which serves up protocol handler for a given set of
 * parameters ( URL/user agent)
 */
public interface RelyingPartyEnabler {

    /**
     * AuthProtocolHandler is an object implementing the finite state machine of
     * the actual protocol. Offer two methods for the factory to create a
     * protocol handler: based just on policy and the other based on policy and
     * the user agent.
     * 
     * @param policy
     *                is a hashMap mapping attributes to a list of values.
     *                Typical attributes are "TokenTypes", "RequiredClaims",
     *                "OptionalClaims"
     * 
     * @return an appropriate authentication handler for this policy
     */
    AuthProtocolHandler createNewSession(Map policy);

    /**
     * @param userAgent
     *                String description of the user-agent
     * @param policy
     *                is a hashMap mapping attributes to a list of values.
     *                Typical attributes are "TokenTypes", "RequiredClaims",
     *                "OptionalClaims"
     * 
     * @return  appropriate authentication handler for this policy and user
     *           agent
     */
    AuthProtocolHandler createNewSession(String userAgent,
            Map policy);

}