/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Suresh Chari (IBM Corporation) - initial implementation
 *******************************************************************************/ 
package org.eclipse.higgins.rp.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.ListIterator;

import org.eclipse.higgins.rp.tokens.RPClaimType;



public class RPClaimTypeImpl implements RPClaimType {

	URI _uri = null;
	String _displayName = null;
	
	public String getDisplayName() {
		if ( _displayName!=null )
			return _displayName;
		else
			return _uri.toASCIIString();
	}

	public URI getName() {
		return _uri;
	}

	public String getShortName() {
		return _uri.toASCIIString(); // makes sense?
	}
	
	public RPClaimTypeImpl (String uriString) throws URISyntaxException{
		_uri = new URI( uriString);
	}

	public void setDisplayName( String name ){
		_displayName = name;
	}

	public RPClaimTypeImpl( URI u){
		_uri = u;
	}
	
	public static String claimListToString( List claimList){
		return claimListToString( claimList, " ");
	}
	
	public static String claimListToString( List claimList, String separator){
		StringBuffer result = null;
		ListIterator itrtr = claimList.listIterator();
		while (itrtr.hasNext()){
			if (result!=null)
				result.append( separator );
			else
				result = new StringBuffer();
			result.append( ((RPClaimType) itrtr.next()).getDisplayName());
		}
		
		return ((result==null)?null:result.toString());
	}
}
