/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Paula Austel, Suresh Chari (IBM Corporation) - initial implementation
 *******************************************************************************/ 
package org.eclipse.higgins.rp.servlet.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.rp.ResultCallback;
import org.eclipse.higgins.rp.servlet.server.CxtConstants;
import org.eclipse.higgins.rp.servlet.server.Invoker;
import org.eclipse.higgins.rp.tokens.RPClaim;
import org.eclipse.higgins.rp.tokens.RPSecurityToken;

public class ResultCallbackHandler implements ResultCallback,Serializable {

	static final long serialVersionUID = 1L;
    protected static Log log = LogFactory.getLog(ResultCallbackHandler.class.getName());
    private String _authSession = null;
	private HttpSession _httpsession = null;
	private Map _mp = null;
	
	public ResultCallbackHandler(String authSession, HttpSession httpsession ){
		_authSession = authSession;
		_httpsession = httpsession;
		_mp = (Map)_httpsession.getAttribute( _authSession);
	}
	
	public void handleFailure(int errCode) {
		Invoker.resetRPState(_authSession,_httpsession);

		// TODO - need to fix how to store and retrieve error page
		String errorpage = (String)_httpsession.getAttribute("ErrorPage");

		switch (errCode){
		case ResultCallback.RP_AUTHENTICATION_INTERNAL_ERROR:
			log.error("authn internal error: forward to "+errorpage);
			 break;
		case ResultCallback.RP_AUTHENTICATION_FAILURE:
			log.error("authn failure - no token: forward to "+errorpage);
			break;
		}
		HttpServletResponse response = (HttpServletResponse)_mp.get( CxtConstants.RESPONSE );
		if(errorpage!= null) {
			// forward to error page
			HttpServletRequest request = (HttpServletRequest)_mp.get(CxtConstants.REQUEST);
			RequestDispatcher rd = request.getRequestDispatcher(errorpage);
			try {
				rd.forward(request, response);
			} catch (ServletException exc1) {
				exc1.printStackTrace();
			} catch (IOException exc2) {
				exc2.printStackTrace();
			}
		}
		else response.setStatus(HttpServletResponse.SC_FORBIDDEN);
		return ;
	}
	public void handleFailure (int errCode, Throwable rootCause) {
		log.debug("remove state from http session: " + _httpsession.getId());
		Invoker.resetRPState(_authSession, _httpsession);
		// TODO - need to fix how to store and retrieve error page
		String errorpage = (String)_httpsession.getAttribute("ErrorPage");
		// TODO - use LogHelper to format exceptions
		switch (errCode){
		case ResultCallback.RP_AUTHENTICATION_INTERNAL_ERROR:
			log.error("authn internal error" + rootCause);
			break;
		case ResultCallback.RP_AUTHENTICATION_FAILURE:
			log.error("authn failure - no token"+ rootCause);
			break;
		}
		HttpServletResponse response = (HttpServletResponse)_httpsession.getAttribute(CxtConstants.RESPONSE);
		// forward to error page
		if(errorpage!= null) {
			// forward to error page
			HttpServletRequest request = (HttpServletRequest)_httpsession.getAttribute(CxtConstants.REQUEST);
			RequestDispatcher rd = request.getRequestDispatcher(errorpage);
			try {
				rd.forward(request, response);
			} catch (ServletException exc1) {
				exc1.printStackTrace();
			} catch (IOException exc2) {
				exc2.printStackTrace();
			}
		}
		else response.setStatus(HttpServletResponse.SC_FORBIDDEN);
	}

	public void handleSuccess(String protectedResource, RPSecurityToken authenticationResult) {
		
		// store the results in the session
		String ret_token = authenticationResult.getTokenType().toString();
		_httpsession.setAttribute(CxtConstants.RET_TOKEN_TYPE, ret_token);
	    _httpsession.setAttribute(CxtConstants.RET_TOKEN_ID, authenticationResult.getAsString());
		List claimList = authenticationResult.getClaims();
		if(null != claimList){
			_httpsession.setAttribute(CxtConstants.RET_CLAIMS, claimList);
			for (int i = 0; i < claimList.size(); ++i){
				RPClaim claim = (RPClaim)claimList.get(i);	
				String attribute = claim.getType().getDisplayName();
				List valList = new ArrayList();
				java.util.Iterator itrtr = claim.getValues();
				int j = 0;
				while(itrtr.hasNext()) {
					valList.add((String)itrtr.next());
					j++;
				}
				String[] values = (String [])valList.toArray( new String[] {});
				_httpsession.setAttribute(attribute, values);	
			}	
		}
		
		// Remove the state associated with this authentication Session
		_httpsession.removeAttribute( _authSession );
		// Redirect user to the original URI
		log.info("Redirecting to " + protectedResource);
		HttpServletResponse response = (HttpServletResponse)_mp.get(CxtConstants.RESPONSE);
		try {
			response.sendRedirect( protectedResource );
		} catch (IOException exc2) {
			exc2.printStackTrace();
		}

		return;
	}
}
