/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Paula Austel, Suresh Chari (IBM Corporation) - initial implementation
 *******************************************************************************/ 
package org.eclipse.higgins.rp.servlet.impl;

import java.io.Serializable;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.eclipse.higgins.rp.SessionContext;
import org.eclipse.higgins.rp.servlet.server.CxtConstants;

// Implementation of the session store using HttpSession

public class SessionContextImpl implements SessionContext, Serializable{

	

	private static final long serialVersionUID = 1L;

	public static final String authenticationStore = "authenticationStore";
	private String _protectedResource = null;
	private HttpSession _httpsession = null;
	
	public SessionContextImpl( String origUri, HttpSession httpsession ){
		_protectedResource = origUri;
		_httpsession = httpsession;
	}

	public SessionContextImpl(HttpSession httpsession ){
		_httpsession = httpsession;
	}
	
	public Object retrieveAttribute(String attribute) {
		
		Object result = (Object)_httpsession.getAttribute(attribute);
		return result;
	}
	
	public Object retrieveAttribute(String authContext, String attribute) {
		Object result = (Object)_httpsession.getAttribute(authContext+"/"+attribute);
		return result;
	}

	public int storeAttribute(String attribute, Object value) {
		
		_httpsession.setAttribute( attribute , value);
		return 1;
	}

	public int storeAttribute(String authContext, String attribute, Object value) {
		_httpsession.setAttribute( authContext+"/"+attribute , value);
		return 1;
	}
	
	public boolean attributeExists(String attribute) {
		Object result = _httpsession.getAttribute(attribute);
		if(null != result)
			return true;
		else return false;
	}
	
	public boolean attributeExists(String authContext, String attribute) {
		Object result = _httpsession.getAttribute(authContext+"/"+attribute);
		if (null != result)
			return true;
		else 
			return false;
	}

	public void deleteAttribute(String attribute) {
		_httpsession.removeAttribute( attribute );
	}

	public void deleteAttribute(String authContext, String attribute) {
		_httpsession.removeAttribute( authContext+"/"+attribute );
	}
	
	
	public String getProtectedResource(){
		return _protectedResource;
	}
	
	public String setProtectedResource(String rsrc) {
		_protectedResource = rsrc;
		return rsrc;
	}

	public String getCurrentRequestUrl() {
		HttpServletRequest req = (HttpServletRequest)_httpsession.getAttribute(CxtConstants.REQUEST);
		String currentUrl = (String)(req.getRequestURL().toString());
        return currentUrl;
	}
	
	
	public String getRealPath(String path) {
		return _httpsession.getServletContext().getRealPath( path );
	}
	
	
	

	
	
}
