/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.i18n;

import java.util.Locale;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.SimpleLocaleContext;

public abstract class LocaleContextHolder {
    private static final ThreadLocal localeContextHolder = new InheritableThreadLocal();

    public static void setLocaleContext(LocaleContext localeContext) {
        localeContextHolder.set(localeContext);
    }

    public static LocaleContext getLocaleContext() {
        return (LocaleContext)localeContextHolder.get();
    }

    public static void setLocale(Locale locale) {
        localeContextHolder.set(locale != null ? new SimpleLocaleContext(locale) : null);
    }

    public static Locale getLocale() {
        LocaleContext localeContext = (LocaleContext)localeContextHolder.get();
        return localeContext != null ? localeContext.getLocale() : Locale.getDefault();
    }
}

