/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.core;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import org.springframework.jms.connection.JmsResourceHolder;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.converter.SimpleMessageConverter102;
import org.springframework.jms.support.destination.DynamicDestinationResolver;

public class JmsTemplate102
extends JmsTemplate {
    static /* synthetic */ Class class$javax$jms$TopicConnection;
    static /* synthetic */ Class class$javax$jms$QueueConnection;
    static /* synthetic */ Class class$javax$jms$TopicSession;
    static /* synthetic */ Class class$javax$jms$QueueSession;

    public JmsTemplate102() {
    }

    public JmsTemplate102(ConnectionFactory connectionFactory, boolean pubSubDomain) {
        this();
        this.setConnectionFactory(connectionFactory);
        this.setPubSubDomain(pubSubDomain);
        this.afterPropertiesSet();
    }

    protected void initDefaultStrategies() {
        this.setDestinationResolver(new DynamicDestinationResolver());
        this.setMessageConverter(new SimpleMessageConverter102());
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.isPubSubDomain()) {
            if (!(this.getConnectionFactory() instanceof TopicConnectionFactory)) {
                throw new IllegalArgumentException("Specified a Spring JMS 1.0.2 template for topics but did not supply an instance of TopicConnectionFactory");
            }
        } else if (!(this.getConnectionFactory() instanceof QueueConnectionFactory)) {
            throw new IllegalArgumentException("Specified a Spring JMS 1.0.2 template for queues but did not supply an instance of QueueConnectionFactory");
        }
    }

    protected Connection getConnection(JmsResourceHolder holder) {
        Class clazz = this.isPubSubDomain() ? (class$javax$jms$TopicConnection == null ? (class$javax$jms$TopicConnection = JmsTemplate102.class$("javax.jms.TopicConnection")) : class$javax$jms$TopicConnection) : (class$javax$jms$QueueConnection == null ? (class$javax$jms$QueueConnection = JmsTemplate102.class$("javax.jms.QueueConnection")) : class$javax$jms$QueueConnection);
        return holder.getConnection(clazz);
    }

    protected Session getSession(JmsResourceHolder holder) {
        Class clazz = this.isPubSubDomain() ? (class$javax$jms$TopicSession == null ? (class$javax$jms$TopicSession = JmsTemplate102.class$("javax.jms.TopicSession")) : class$javax$jms$TopicSession) : (class$javax$jms$QueueSession == null ? (class$javax$jms$QueueSession = JmsTemplate102.class$("javax.jms.QueueSession")) : class$javax$jms$QueueSession);
        return holder.getSession(clazz);
    }

    protected Connection createConnection() throws JMSException {
        if (this.isPubSubDomain()) {
            return ((TopicConnectionFactory)this.getConnectionFactory()).createTopicConnection();
        }
        return ((QueueConnectionFactory)this.getConnectionFactory()).createQueueConnection();
    }

    protected Session createSession(Connection con) throws JMSException {
        if (this.isPubSubDomain()) {
            return ((TopicConnection)con).createTopicSession(this.isSessionTransacted(), this.getSessionAcknowledgeMode());
        }
        return ((QueueConnection)con).createQueueSession(this.isSessionTransacted(), this.getSessionAcknowledgeMode());
    }

    protected MessageProducer doCreateProducer(Session session, Destination destination) throws JMSException {
        if (this.isPubSubDomain()) {
            return ((TopicSession)session).createPublisher((Topic)destination);
        }
        return ((QueueSession)session).createSender((Queue)destination);
    }

    protected MessageConsumer createConsumer(Session session, Destination destination, String messageSelector) throws JMSException {
        if (this.isPubSubDomain()) {
            return ((TopicSession)session).createSubscriber((Topic)destination, messageSelector, this.isPubSubNoLocal());
        }
        return ((QueueSession)session).createReceiver((Queue)destination, messageSelector);
    }

    protected void doSend(MessageProducer producer, Message message) throws JMSException {
        if (this.isPubSubDomain()) {
            if (this.isExplicitQosEnabled()) {
                ((TopicPublisher)producer).publish(message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
            } else {
                ((TopicPublisher)producer).publish(message);
            }
        } else if (this.isExplicitQosEnabled()) {
            ((QueueSender)producer).send(message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
        } else {
            ((QueueSender)producer).send(message);
        }
    }

    protected boolean isClientAcknowledge(Session session) throws JMSException {
        return this.getSessionAcknowledgeMode() == 2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

