/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.config.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openxri.config.ProxyConfig;
import org.openxri.xml.XRD;

public class PropertiesProxyConfig
implements ProxyConfig {
    public static final String PROXY_CONFIG_FILE = "proxy.config.file";
    public static final String DEFAULT_PROXY_CONFIG_FILE = "/WEB-INF/proxy.properties";
    private static Log logger = LogFactory.getLog((String)PropertiesProxyConfig.class.getName());
    protected Properties config;
    protected String configFile;

    public PropertiesProxyConfig(ServletContext servletContext, Properties properties) {
        this.config = null;
        this.configFile = properties.getProperty(PROXY_CONFIG_FILE, DEFAULT_PROXY_CONFIG_FILE);
        if (servletContext != null) {
            this.configFile = servletContext.getRealPath(this.configFile);
        }
    }

    public PropertiesProxyConfig(Properties config) {
        this.config = config;
        this.configFile = null;
    }

    public PropertiesProxyConfig(String configFile) {
        this.config = null;
        this.configFile = configFile;
    }

    public PropertiesProxyConfig() {
        this.config = null;
        this.configFile = null;
    }

    public void init() {
        if (this.config == null) {
            this.config = new Properties();
            try {
                FileInputStream stream = new FileInputStream(new File(this.configFile));
                this.config.load(stream);
                ((InputStream)stream).close();
            }
            catch (Exception ex) {
                logger.error((Object)"Cannot read properties file.", (Throwable)ex);
            }
        }
    }

    public void persist() {
        try {
            this.config.store(new FileOutputStream(this.configFile), null);
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to store configuration properties", (Throwable)ex);
        }
    }

    public String getSetting(String key) {
        return this.config.getProperty(key);
    }

    public String getProxyImplClass() {
        return this.config.getProperty("proxy.class", ProxyConfig.DEFAULT_PROXY_CLASS);
    }

    public void setProxyImplClass(String value) {
        this.setProp("proxy.class", value);
    }

    public XRD getEqualsAuthority() throws URISyntaxException, ParseException {
        String sDescriptor = this.config.getProperty("EqualsAuthority", null);
        return XRD.parseXRD((String)sDescriptor, (boolean)false);
    }

    public void setEqualsAuthority(XRD oVal) {
        this.setProp("EqualsAuthority", oVal.toString());
    }

    public XRD getAtAuthority() throws URISyntaxException, ParseException {
        String sDescriptor = this.config.getProperty("AtAuthority", null);
        return XRD.parseXRD((String)sDescriptor, (boolean)false);
    }

    public void setAtAuthority(XRD oVal) {
        this.setProp("AtAuthority", oVal.toString());
    }

    public XRD getBangAuthority() throws URISyntaxException, ParseException {
        String sDescriptor = this.config.getProperty("BangAuthority", null);
        return XRD.parseXRD((String)sDescriptor, (boolean)false);
    }

    public void setBangAuthority(XRD oVal) {
        this.setProp("BangAuthority", oVal.toString());
    }

    public int getMaxBytesPerRequest() {
        return Integer.parseInt(this.config.getProperty("MaxBytesPerRequest", "512000"));
    }

    public int getMaxFollowRedirects() {
        return Integer.parseInt(this.config.getProperty("MaxFollowRedirects", "10"));
    }

    public int getMaxFollowRefs() {
        return Integer.parseInt(this.config.getProperty("MaxFollowRefs", "10"));
    }

    public int getMaxHttpRedirectAllowed() {
        return Integer.parseInt(this.config.getProperty("MaxFollowRedirects", "10"));
    }

    public int getMaxRequests() {
        return Integer.parseInt(this.config.getProperty("MaxRequests", "10"));
    }

    public int getMaxTotalBytes() {
        return Integer.parseInt(this.config.getProperty("MaxTotalBytes", "1048576"));
    }

    public String[] getSupportedResMediaTypes() {
        String mediaTypes = this.config.getProperty("SupportedResMediaTypes", null);
        return mediaTypes.split("\\s*,\\s*");
    }

    public String[] getHttpsBypassAuthorities() {
        String authorities = this.config.getProperty("HttpsBypassAuthorities", null);
        if (authorities == null) {
            return new String[0];
        }
        return authorities.split("\\s+");
    }

    public void setMaxBytesPerRequest(int maxBytesPerRequest) {
        this.setProp("MaxBytesPerRequest", Integer.toString(maxBytesPerRequest));
    }

    public void setMaxFollowRedirects(int maxFollowRedirects) {
        this.setProp("MaxFollowRedirects", Integer.toString(maxFollowRedirects));
    }

    public void setMaxFollowRefs(int maxFollowRefs) {
        this.setProp("MaxFollowRefs", Integer.toString(maxFollowRefs));
    }

    public void setMaxRequests(int maxRequests) {
        this.setProp("MaxRequests", Integer.toString(maxRequests));
    }

    public void setMaxTotalBytes(int maxTotalBytes) {
        this.setProp("MaxTotalBytes", Integer.toString(maxTotalBytes));
    }

    public void setSupportedResMediaTypes(String[] mediaTypes) {
        StringBuffer join = new StringBuffer();
        for (int i = 0; i < mediaTypes.length; ++i) {
            join.append((i > 0 ? ", " : "") + mediaTypes[i]);
        }
        this.setProp("SupportedResMediaTypes", join.toString());
    }

    public void setHttpsBypassAuthorities(String[] authorities) {
        StringBuffer join = new StringBuffer();
        for (int i = 0; i < authorities.length; ++i) {
            if (join.length() > 0) {
                join.append(" ");
            }
            join.append(authorities[i]);
        }
        this.setProp("HttpsBypassAuthorities", join.toString());
    }

    public String getBareXRINotFoundRedirect() {
        return this.config.getProperty("BareXRINotFoundRedirect");
    }

    public void setBareXRINotFoundRedirect(String bareXRINotFoundRedirect) {
        this.setProp("BareXRINotFoundRedirect", bareXRINotFoundRedirect);
    }

    public String getRootRedirect() {
        return this.config.getProperty("RootRedirect");
    }

    public void setRootRedirect(String rootRedirect) {
        this.setProp("RootRedirect", rootRedirect);
    }

    private void setProp(String sKey, String sValue) {
        if (sValue == null) {
            this.config.remove(sKey);
        } else {
            this.config.put(sKey, sValue);
        }
    }
}

