/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.config.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openxri.config.PipelineRegistry;
import org.openxri.config.impl.XMLServerConfig;
import org.openxri.pipeline.Pipeline;
import org.openxri.pipeline.Stage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XMLPipelineRegistry
implements PipelineRegistry {
    private static Log log = LogFactory.getLog((String)XMLPipelineRegistry.class.getName());
    public static final String DEFAULT_CREATE_PIPELINE_NAME = "create";
    public static final String DEFAULT_LOOKUP_PIPELINE_NAME = "lookup";
    private List<Pipeline> pipelineList;
    private Map<String, Pipeline> pipelineMap;

    XMLPipelineRegistry(List<XMLServerConfig.PipelineConfig> pipelineConfigs, ClassLoader classLoader) {
        this.load(pipelineConfigs, classLoader);
    }

    XMLPipelineRegistry(List<XMLServerConfig.PipelineConfig> pipelineConfigs) {
        this.load(pipelineConfigs, Thread.currentThread().getContextClassLoader());
    }

    private void load(List<XMLServerConfig.PipelineConfig> pipelineConfigs, ClassLoader classLoader) {
        this.pipelineList = new ArrayList<Pipeline>();
        this.pipelineMap = new HashMap<String, Pipeline>();
        for (XMLServerConfig.PipelineConfig pipelineConfig : pipelineConfigs) {
            ArrayList<Stage> stages = new ArrayList<Stage>();
            for (XMLServerConfig.StageConfig stageConfig : pipelineConfig.getStageConfigs()) {
                Stage stage;
                Class<?> implementationClass;
                String implementationName = stageConfig.getClassName();
                try {
                    implementationClass = classLoader.loadClass(implementationName);
                }
                catch (ClassNotFoundException ex) {
                    log.error((Object)("Stage implementation not found: " + implementationName), (Throwable)ex);
                    continue;
                }
                Properties properties = stageConfig.getProperties();
                try {
                    Class[] constructorArgs = new Class[]{Properties.class};
                    Constructor<?> constructor = implementationClass.getConstructor(constructorArgs);
                    stage = (Stage)constructor.newInstance(properties);
                    stage.init();
                }
                catch (NoSuchMethodException ex) {
                    log.error((Object)("Stage " + implementationName + " does not have a constructor that takes a java.util.Properties object."), (Throwable)ex);
                    continue;
                }
                catch (InstantiationException ex) {
                    log.error((Object)("Cannot instantiate stage " + implementationName + "."), (Throwable)ex);
                    continue;
                }
                catch (IllegalAccessException ex) {
                    log.error((Object)("Illegal access to constructor of stage " + implementationName + "."), (Throwable)ex);
                    continue;
                }
                catch (InvocationTargetException ex) {
                    log.error((Object)("Cannot invoke constructor of stage " + implementationName + "."), (Throwable)ex);
                    continue;
                }
                catch (Exception ex) {
                    log.error((Object)("Cannot construct stage " + implementationName + "."), (Throwable)ex);
                    continue;
                }
                stages.add(stage);
            }
            String name = pipelineConfig.getName();
            Pipeline pipeline = new Pipeline(name, stages);
            this.pipelineList.add(pipeline);
            this.pipelineMap.put(name, pipeline);
        }
    }

    @Override
    public void init() {
    }

    @Override
    public List<Pipeline> getPipelines() {
        if (this.pipelineList == null) {
            throw new IllegalStateException("Not initialized.");
        }
        return this.pipelineList;
    }

    @Override
    public Pipeline getPipelineByName(String name) {
        if (this.pipelineMap == null) {
            throw new IllegalStateException("Not initialized.");
        }
        return this.pipelineMap.get(name);
    }

    @Override
    public Pipeline getDefaultCreatePipeline() {
        return this.getPipelineByName(DEFAULT_CREATE_PIPELINE_NAME);
    }

    @Override
    public Pipeline getDefaultLookupPipeline() {
        return this.getPipelineByName(DEFAULT_LOOKUP_PIPELINE_NAME);
    }
}

