/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.pipeline.stages;

import java.util.Date;
import java.util.Properties;
import org.openxri.XRISegment;
import org.openxri.exceptions.StageException;
import org.openxri.pipeline.stages.AbstractStage;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.xml.XRD;

public class AddExpiresRelativeStage
extends AbstractStage {
    public static final String PROPERTIES_KEY_SECONDS = "seconds";
    public static final String DEFAULT_SECONDS = "7200";
    private Long seconds;

    public AddExpiresRelativeStage(Properties properties) {
        super(properties);
    }

    public void init() throws Exception {
        String seconds = this.properties.getProperty(PROPERTIES_KEY_SECONDS, DEFAULT_SECONDS);
        this.seconds = new Long(seconds);
    }

    public XRD execute(Store store, XRD xrd, XRISegment segment, Authority parentAuthority, String subSegmentName, Authority authority, boolean isCreate) throws StageException {
        if (this.seconds == null) {
            throw new StageException("Not initialized.");
        }
        xrd.setExpires(new Date(new Date().getTime() + this.seconds * 1000L));
        return xrd;
    }
}

