/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.pipeline.stages;

import java.util.Properties;
import org.openxri.XRISegment;
import org.openxri.exceptions.StageException;
import org.openxri.factories.ServerConfigFactory;
import org.openxri.pipeline.Pipeline;
import org.openxri.pipeline.stages.AbstractStage;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.xml.XRD;

public class ExecutePipelineStage
extends AbstractStage {
    public static final String PROPERTIES_KEY_PIPELINE = "pipeline";
    private Pipeline pipeline;

    public ExecutePipelineStage(Properties properties) {
        super(properties);
    }

    public void init() throws StageException {
        String pipeline = this.properties.getProperty(PROPERTIES_KEY_PIPELINE);
        if (pipeline == null) {
            throw new StageException("Required property pipeline not found.");
        }
        this.pipeline = ServerConfigFactory.getSingleton().getPipelineRegistry().getPipelineByName(pipeline);
    }

    public XRD execute(Store store, XRD xrd, XRISegment segment, Authority parentAuthority, String subSegmentName, Authority authority, boolean isCreate) throws StageException {
        xrd = this.pipeline.execute(store, xrd, segment, parentAuthority, subSegmentName, authority, isCreate);
        return xrd;
    }
}

