/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.plugin.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openxri.config.impl.AbstractComponent;
import org.openxri.exceptions.StoreException;
import org.openxri.factories.ServerConfigFactory;
import org.openxri.plugin.Plugin;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.store.StoreResettable;
import org.openxri.store.SubSegment;
import org.openxri.xml.DefaultService;
import org.openxri.xml.Service;
import org.openxri.xml.XRD;

public class SampleDataPlugin
extends AbstractComponent
implements Plugin {
    private static Log log = LogFactory.getLog((String)SampleDataPlugin.class.getName());
    public static final String LOAD_SAMPLE_DATA_PATH = "load-sample-data";

    public SampleDataPlugin(Properties properties) {
        super(properties);
    }

    public void init() {
    }

    private XRD makeSampleXRD() {
        XRD xrd = new XRD();
        try {
            DefaultService defaultService = new DefaultService(new URI("http://www.openxri.org"));
            xrd.addService((Service)defaultService);
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
        }
        return xrd;
    }

    public boolean processCustomRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.trace((Object)"processCustomRequest()");
        if (!request.getPathInfo().replace("/", "").equals(LOAD_SAMPLE_DATA_PATH)) {
            return false;
        }
        Store store = (Store)ServerConfigFactory.getSingleton().getComponentRegistry().getComponent(Store.class);
        try {
            if (store instanceof StoreResettable) {
                ((StoreResettable)store).resetStore();
            }
            SubSegment rootSubSegment1 = store.createRootSubSegment("=example", new XRD());
            Authority rootAuthority1 = store.getSubSegmentAuthority(rootSubSegment1);
            SubSegment subSegment1 = store.registerSubsegment(rootAuthority1, "*name1", this.makeSampleXRD());
            SubSegment subSegment2 = store.registerSubsegment(rootAuthority1, "*name2", this.makeSampleXRD());
            SubSegment rootSubSegment2 = store.createRootSubSegment("@example", new XRD());
            Authority rootAuthority2 = store.getSubSegmentAuthority(rootSubSegment2);
            SubSegment subSegment3 = store.registerSubsegment(rootAuthority2, "*name3", this.makeSampleXRD());
            Authority authority3 = store.getSubSegmentAuthority(subSegment3);
            SubSegment subSegment4 = store.registerSubsegment(authority3, "*name4", this.makeSampleXRD());
        }
        catch (StoreException ex) {
            ex.printStackTrace();
        }
        response.getWriter().print("Sample data successfully loaded.");
        return true;
    }

    public void shutdown() {
    }
}

