/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.proxy.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openxri.XRI;
import org.openxri.XRIParseException;
import org.openxri.config.ProxyConfig;
import org.openxri.proxy.Proxy;
import org.openxri.proxy.ProxyException;
import org.openxri.resolve.MimeType;
import org.openxri.resolve.Resolver;
import org.openxri.resolve.TrustType;
import org.openxri.resolve.exception.IllegalTrustTypeException;
import org.openxri.resolve.exception.PartialResolutionException;
import org.openxri.util.URLUtils;
import org.openxri.xml.Service;
import org.openxri.xml.Status;
import org.openxri.xml.XRD;
import org.openxri.xml.XRDS;

public class OpenIDHackProxy
implements Proxy {
    protected ProxyConfig config;
    protected static Log log = LogFactory.getLog((String)OpenIDHackProxy.class.getName());
    public static final String _XRD_R = "_xrd_r";
    public static final String _XRD_T = "_xrd_t";
    public static final String _XRD_M = "_xrd_m";
    public static final String HTTP_ERROR_CONTENT_TYPE = "text/plain; charset=UTF-8";
    public static final String HTTP_XML_CONTENT_TYPE = "text/xml; charset=UTF-8";
    protected boolean supportXRDS = false;
    protected boolean supportXRD = false;
    protected boolean supportURIList = false;
    protected boolean supportRedirect = false;
    protected Resolver resolver = null;

    public OpenIDHackProxy(ProxyConfig config) {
        this.config = config;
    }

    public void init() throws ProxyException {
        this.resolver = new Resolver();
        this.resolver.setMaxHttpRedirects(this.config.getMaxFollowRedirects());
        this.resolver.setMaxFollowRefs(this.config.getMaxFollowRefs());
        this.resolver.setMaxRequests(this.config.getMaxRequests());
        this.resolver.setMaxTotalBytes(this.config.getMaxTotalBytes());
        this.resolver.setMaxBytesPerRequest(this.config.getMaxBytesPerRequest());
        try {
            this.resolver.setAuthority("=", this.config.getEqualsAuthority());
            this.resolver.setAuthority("@", this.config.getAtAuthority());
            this.resolver.setAuthority("!", this.config.getBangAuthority());
        }
        catch (Exception ex) {
            throw new ProxyException("Cannot initialize Resolver. Check the =, @ and ! root authorities.", ex);
        }
        String[] supports = this.config.getSupportedResMediaTypes();
        if (supports != null) {
            for (int i = 0; i < supports.length; ++i) {
                String type = supports[i].trim().toLowerCase();
                if (type.equals("text/uri-list")) {
                    this.supportURIList = true;
                    continue;
                }
                if (type.equals("application/xrd+xml")) {
                    this.supportXRD = true;
                    continue;
                }
                if (type.equals("application/xrds+xml")) {
                    this.supportXRDS = true;
                    continue;
                }
                if (type.equals("redirect")) {
                    this.supportRedirect = true;
                    continue;
                }
                log.warn((Object)("unknown resolution media type: " + type));
            }
        }
    }

    public void process(HttpServletRequest request, HttpServletResponse response) {
        boolean isDumbBrowser = true;
        log.trace((Object)"doGet() - enter");
        log.debug((Object)("Request: " + request.getRequestURI()));
        try {
            if (this.resolver == null) {
                log.error((Object)"proxy not initialized check configuration");
                this.sendResponse(response, HTTP_ERROR_CONTENT_TYPE, "TEMPORARY_FAIL(code=300): proxy not available", null);
                return;
            }
            String context = request.getContextPath();
            String sPath = request.getRequestURI().substring(context.length());
            if (sPath == null || sPath.length() <= 1 || sPath.charAt(0) != '/') {
                this.sendResponse(response, 404, HTTP_ERROR_CONTENT_TYPE, "INVALID_INPUT(code=210), no path exists", null);
                return;
            }
            sPath = sPath.substring(1);
            log.trace((Object)("Checking path (" + sPath + ") to see if auto-correction is necessary"));
            String autoCorrected = this.checkAutoCorrect(sPath);
            if (autoCorrected != null) {
                String newURL = this.buildAbsoluteURL(request, autoCorrected);
                log.debug((Object)("Redirecting to URL " + newURL));
                response.sendRedirect(newURL);
                return;
            }
            log.trace((Object)"Auto-correction not needed");
            String sAccept = request.getHeader("Accept");
            MimeType resolutionMediaType = null;
            String serviceResMediaType = null;
            String serviceType = null;
            if (sAccept != null) {
                StringTokenizer tokenizer = new StringTokenizer(sAccept, ",");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    MimeType mType = MimeType.parse((String)token);
                    if (mType == null || mType.getType() == null || mType.getType().length() == 0) continue;
                    if (mType.isValidXriResMediaType()) {
                        resolutionMediaType = mType;
                        serviceResMediaType = null;
                        isDumbBrowser = false;
                        break;
                    }
                    resolutionMediaType = null;
                    serviceResMediaType = mType.toString();
                    break;
                }
            }
            QueryParams qp = this.parseQuery(request);
            if (qp.xrdR != null) {
                if (qp.xrdR.trim().length() == 0) {
                    resolutionMediaType = null;
                } else {
                    MimeType mType = MimeType.parse((String)qp.xrdR);
                    if (mType != null && mType.getType() != null && mType.getType().length() > 0) {
                        resolutionMediaType = mType;
                    }
                }
            }
            serviceType = qp.xrdT != null && qp.xrdT.trim().length() == 0 ? null : qp.xrdT;
            if (qp.xrdM != null && qp.xrdM.trim().length() == 0) {
                serviceResMediaType = qp.xrdM;
            }
            if (qp.opaque != null) {
                sPath = sPath + '?' + qp.opaque;
            }
            log.debug((Object)("User-Agent: " + request.getHeader("User-Agent")));
            if (request.getHeader("User-Agent") == null) {
                String identifier = request.getRequestURI().substring(request.getContextPath().length() + 1);
                XRD xrd = this.resolver.resolveSEPToXRD(sPath, new TrustType("none"), "http://openid.net/signon/1.0", null, true);
                if (xrd == null || xrd.getSelectedServices().getList().size() == 0) {
                    this.sendResponse(response, HTTP_ERROR_CONTENT_TYPE, "SEP_NOT_FOUND(code=241): no authentication url found", null);
                    return;
                }
                String server = ((Service)xrd.getSelectedServices().getList().get(0)).getURIAt(0).getUriString();
                log.debug((Object)("OpenID hack triggered: Server=" + server + ", Identifier=" + identifier));
                this.outputOpenIDServerHack(response, server);
                return;
            }
            this.processProxyRequest(sPath, resolutionMediaType, serviceType, serviceResMediaType, request, response, isDumbBrowser);
        }
        catch (Throwable the) {
            log.fatal((Object)("Received RuntimeExeption while processing request: path=" + request.getPathInfo() + " error: " + the));
            the.printStackTrace();
            this.sendFatalError(response, the.getMessage());
        }
    }

    private boolean checkSupportedMediaTypes(HttpServletResponse oResp, MimeType resMediaType) throws IOException {
        String notImplemented = "NOT_IMPLEMENTED(code=201): Resolution media type '" + resMediaType + "' is not supported by this proxy";
        if (resMediaType == null) {
            if (!this.supportRedirect) {
                this.sendResponse(oResp, HTTP_ERROR_CONTENT_TYPE, "NOT_IMPLEMENTED(code=201): HTTP redirect resolution mechanism is not supported by this proxy", null);
                return false;
            }
            return true;
        }
        if (!resMediaType.isValidXriResMediaType()) {
            this.sendResponse(oResp, HTTP_ERROR_CONTENT_TYPE, "INVALID_RESOLUTION_MEDAIA_TYPE(code=212): Unknown media type '" + resMediaType + "'", null);
            return false;
        }
        if (resMediaType.isType("application/xrds+xml") && !this.supportXRDS) {
            this.sendResponse(oResp, HTTP_ERROR_CONTENT_TYPE, notImplemented, null);
            return false;
        }
        if (resMediaType.isType("application/xrd+xml") && !this.supportXRD) {
            this.sendResponse(oResp, HTTP_ERROR_CONTENT_TYPE, notImplemented, null);
            return false;
        }
        if (resMediaType.isType("text/uri-list") && !this.supportURIList) {
            this.sendResponse(oResp, HTTP_ERROR_CONTENT_TYPE, notImplemented, null);
            return false;
        }
        return true;
    }

    private String checkAutoCorrect(String s) {
        int i = 0;
        if (s.length() > 6 && s.substring(0, 6).equalsIgnoreCase("xri://")) {
            i = 6;
        }
        if ((i = s.indexOf(47, i)) == -1) {
            return null;
        }
        String path = s.substring(i + 1);
        String pathQuoted = this.quotePath(path);
        if (pathQuoted.equals(path)) {
            return null;
        }
        String newXRI = s.substring(0, i + 1) + pathQuoted;
        return newXRI;
    }

    private void processProxyRequest(String qxri, MimeType resMediaType, String serviceType, String serviceMediaType, HttpServletRequest request, HttpServletResponse response, boolean isDumbBrowser) throws IOException {
        log.trace((Object)"processProxyRequest - enter");
        if (!this.checkSupportedMediaTypes(response, resMediaType)) {
            log.trace((Object)"processProxyRequest - checkSupportedMediaTypes returned false, returning.");
            return;
        }
        if (qxri == null || qxri.length() == 0) {
            log.debug((Object)"processProxyRequest - sXRI is null or empty");
            this.sendResponse(response, HTTP_ERROR_CONTENT_TYPE, "INVALID_QXRI(code=211): null or empty", null);
            return;
        }
        XRI oXRI = null;
        try {
            oXRI = XRI.fromURINormalForm((String)qxri);
        }
        catch (XRIParseException oEx) {
            log.warn((Object)("Error constructing XRI: " + qxri + ", " + (Object)((Object)oEx)));
            this.sendResponse(response, HTTP_ERROR_CONTENT_TYPE, "INVALID_QXRI(code=211): " + oEx.getMessage(), null);
            return;
        }
        TrustType trustType = new TrustType();
        boolean refs = true;
        boolean sep = true;
        String tempStr = null;
        if (resMediaType != null) {
            tempStr = resMediaType.getParam("refs");
            if (tempStr != null && tempStr.equals("false")) {
                refs = false;
            }
            if ((tempStr = resMediaType.getParam("sep")) != null && tempStr.equals("false")) {
                sep = false;
            }
            if ((tempStr = resMediaType.getParam("trust")) != null) {
                try {
                    trustType.setType(tempStr);
                }
                catch (IllegalTrustTypeException e) {
                    this.sendResponse(response, HTTP_ERROR_CONTENT_TYPE, "INVALID_RESOLUTION_MEDAIA_TYPE(code=212): " + resMediaType, null);
                    return;
                }
            }
        }
        XRDS xrds = null;
        XRD xrd = null;
        try {
            if (sep) {
                if (resMediaType == null) {
                    ArrayList uris = this.resolver.resolveSEPToURIList(oXRI.toString(), trustType, serviceType, serviceMediaType, refs);
                    if (uris == null || uris.size() == 0) {
                        this.sendResponse(response, HTTP_ERROR_CONTENT_TYPE, "SEP_NOT_FOUND(code=241): no url found", null);
                        return;
                    }
                    String s = (String)uris.get(0);
                    log.trace((Object)("Sending redirect to '" + s + "'"));
                    response.sendRedirect(s);
                } else if (resMediaType.isType("text/uri-list")) {
                    String text = this.resolver.resolveSEPToTextURIList(oXRI.toString(), trustType, serviceType, serviceMediaType, refs);
                    if (text.length() <= 0) {
                        this.sendResponse(response, HTTP_ERROR_CONTENT_TYPE, "SEP_NOT_FOUND(code=241): no url found", null);
                    } else {
                        this.sendResponse(response, resMediaType.getType(), text, null);
                    }
                } else if (resMediaType.isType("application/xrds+xml")) {
                    xrds = this.resolver.resolveSEPToXRDS(oXRI, trustType, serviceType, serviceMediaType, refs);
                    this.sendResponse(response, isDumbBrowser, resMediaType.getType(), xrds.toString(), trustType);
                } else if (resMediaType.isType("application/xrd+xml")) {
                    xrd = this.resolver.resolveSEPToXRD(oXRI, trustType, serviceType, serviceMediaType, refs);
                    this.sendResponse(response, isDumbBrowser, resMediaType.getType(), xrd.toResultString(), trustType);
                } else {
                    log.error((Object)"processProxyRequest - should not reach here (sep=true)");
                }
            } else {
                if (resMediaType == null) {
                    resMediaType = new MimeType("application/xrds+xml");
                }
                if (resMediaType.isType("application/xrds+xml")) {
                    xrds = this.resolver.resolveAuthToXRDS(oXRI, trustType, refs);
                    this.sendResponse(response, isDumbBrowser, resMediaType.getType(), xrds.toString(), trustType);
                    return;
                }
                if (resMediaType.isType("application/xrd+xml")) {
                    xrd = this.resolver.resolveAuthToXRD(oXRI, trustType, refs);
                    this.sendResponse(response, isDumbBrowser, resMediaType.getType(), xrd.toString(), trustType);
                } else if (resMediaType.isType("text/uri-list")) {
                    log.warn((Object)"text/uri-list given but does not want to do service selection");
                } else {
                    log.error((Object)"processProxyRequest - should not reach here (sep=false)");
                }
            }
            return;
        }
        catch (PartialResolutionException pre) {
            log.info((Object)"processProxyRequest - caught PartialResolutionException");
            xrds = pre.getPartialXRDS();
            this.sendPartialResponse(request, response, isDumbBrowser, resMediaType, xrds, trustType);
            return;
        }
    }

    private String quotePath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        char first = path.charAt(0);
        switch (first) {
            case '!': 
            case '$': 
            case '+': 
            case '=': 
            case '@': {
                int i = path.indexOf(47);
                if (i == -1) {
                    return "(" + path + ")";
                }
                return "(" + path.substring(0, i) + ")" + path.substring(i);
            }
        }
        return path;
    }

    protected String buildAbsoluteURL(HttpServletRequest request, String relPath) {
        StringBuffer sb = new StringBuffer();
        sb.append(request.getContextPath());
        log.trace((Object)("context='" + request.getContextPath() + "'"));
        log.trace((Object)("path='" + request.getServletPath() + "'"));
        log.trace((Object)("sb='" + sb + "'"));
        int len = sb.length();
        if (len > 1 && sb.charAt(len - 1) != '/') {
            sb.append('/');
        }
        log.trace((Object)("sb2='" + sb + "'"));
        sb.append(request.getServletPath());
        len = sb.length();
        if (len > 1 && sb.charAt(len - 1) != '/') {
            sb.append('/');
        }
        if (sb.length() == 0) {
            sb.append('/');
        }
        log.trace((Object)("sb3='" + sb + "'"));
        sb.append(relPath);
        if (request.getQueryString() != null) {
            sb.append('?');
            sb.append(request.getQueryString());
        }
        log.trace((Object)("sb4='" + sb + "'"));
        return sb.toString();
    }

    protected void sendFatalError(HttpServletResponse resp, String errorMessage) {
        resp.setStatus(200);
        resp.setContentType(HTTP_ERROR_CONTENT_TYPE);
        try {
            ServletOutputStream out = resp.getOutputStream();
            out.println("The proxy has encountered a fatal error. Internal error message follows: ");
            out.println(errorMessage);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void sendPartialResponse(HttpServletRequest request, HttpServletResponse response, boolean isDumbBrowser, MimeType resMediaType, XRDS partialXRDS, TrustType trustType) throws IOException {
        log.trace((Object)("sendPartialResponse(dumbBrowser=" + isDumbBrowser + ", partialXRDS=" + partialXRDS.toString()));
        response.setStatus(200);
        XRD xrd = partialXRDS.getFinalXRD();
        String errMsg = "";
        if (xrd != null) {
            Status stat = xrd.getStatus();
            errMsg = "Error code: " + stat.getCode() + " - " + stat.getText();
        }
        if (resMediaType == null) {
            this.sendResponse(response, HTTP_ERROR_CONTENT_TYPE, errMsg, null);
        } else if (resMediaType.isType("text/uri-list")) {
            errMsg = "# " + errMsg;
            this.sendResponse(response, HTTP_ERROR_CONTENT_TYPE, errMsg, trustType);
        } else if (resMediaType.isType("application/xrds+xml")) {
            this.sendResponse(response, isDumbBrowser, resMediaType.getType(), partialXRDS.toString(), trustType);
        } else if (resMediaType.isType("application/xrd+xml")) {
            this.sendResponse(response, isDumbBrowser, resMediaType.getType(), xrd.toString(), trustType);
        } else {
            log.error((Object)"processProxyRequest - should not reach here (exception)");
        }
    }

    protected void sendResponse(HttpServletResponse response, boolean isDumbBrowser, String contentType, String result, TrustType trustType) throws IOException {
        if (isDumbBrowser) {
            this.sendResponse(response, HTTP_XML_CONTENT_TYPE, result, trustType);
        } else {
            this.sendResponse(response, contentType, result, trustType);
        }
    }

    protected void sendResponse(HttpServletResponse response, String contentType, String result, TrustType trustType) throws IOException {
        this.sendResponse(response, 200, contentType, result, trustType);
    }

    protected void sendResponse(HttpServletResponse response, int statusCode, String contentType, String result, TrustType trustType) throws IOException {
        response.setStatus(statusCode);
        if (trustType != null) {
            contentType = contentType + ";" + trustType.getParameterPair();
        }
        response.setContentType(contentType);
        response.getOutputStream().print(result);
    }

    protected QueryParams parseQuery(HttpServletRequest req) {
        QueryParams qp = new QueryParams();
        String queryString = req.getQueryString();
        String xrdR = null;
        String xrdT = null;
        String xrdM = null;
        StringBuffer opaque = new StringBuffer();
        if (queryString == null) {
            return qp;
        }
        log.trace((Object)("parseQuery() - queryString.length=" + queryString.length()));
        int start = 0;
        while (start < queryString.length()) {
            String val;
            String key;
            String kvpair;
            log.trace((Object)("parseQuery() - start=" + start));
            int i = queryString.indexOf(38, start);
            log.trace((Object)("parseQuery() - i=" + i));
            if (i == -1) {
                kvpair = queryString.substring(start);
                start = queryString.length();
            } else {
                kvpair = queryString.substring(start, i);
                start = i + 1;
            }
            int eq = kvpair.indexOf(61);
            if (eq == -1) {
                key = kvpair;
                val = "";
            } else {
                key = kvpair.substring(0, eq);
                val = kvpair.substring(eq + 1);
            }
            if (xrdR == null && key.toLowerCase().equals(_XRD_R)) {
                log.trace((Object)("parseQuery() - xrdR=" + val));
                xrdR = val;
                continue;
            }
            if (xrdT == null && key.toLowerCase().equals(_XRD_T)) {
                log.trace((Object)("parseQuery() - xrdT=" + val));
                xrdT = val;
                continue;
            }
            if (xrdM == null && key.toLowerCase().equals(_XRD_M)) {
                log.trace((Object)("parseQuery() - xrdM=" + val));
                xrdM = val;
                continue;
            }
            log.trace((Object)("parseQuery() - param=" + kvpair));
            if (opaque.length() > 0) {
                opaque.append('&');
            }
            opaque.append(kvpair);
        }
        qp.xrdR = URLUtils.decode(xrdR);
        qp.xrdT = URLUtils.decode(xrdT);
        qp.xrdM = URLUtils.decode(xrdM);
        qp.opaque = opaque.length() > 0 ? opaque.toString() : null;
        log.trace((Object)("parseQuery() - xrdR=" + qp.xrdR + ", xrdT=" + qp.xrdT + ", xrdM=" + qp.xrdM + ", opaque=" + qp.opaque));
        return qp;
    }

    private void outputOpenIDServerHack(HttpServletResponse response, String server) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.println("<html><head>\n");
        writer.println("<link rel=\"openid.server\" href=\"" + server + "\">");
        writer.println("</head>");
        writer.println("<body>");
        writer.println("Hi there. If you see this, some funny happened.");
        writer.println("</body>");
        writer.println("</html>");
    }

    private void outputOpenIDDelegateHack(HttpServletResponse response, String server, String identifier) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.println("<html><head>\n");
        writer.println("<link rel=\"openid.server\" href=\"" + server + "\">");
        writer.println("<link rel=\"openid.delegate\" href=\"" + identifier + "\">");
        writer.println("</head>");
        writer.println("<body>");
        writer.println("Hi there. If you see this, some funny happened.");
        writer.println("</body>");
        writer.println("</html>");
    }

    protected class QueryParams {
        String xrdR = null;
        String xrdT = null;
        String xrdM = null;
        String opaque = null;

        protected QueryParams() {
        }
    }
}

