/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.server.impl;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openxri.GCSAuthority;
import org.openxri.IRIUtils;
import org.openxri.XRIAuthority;
import org.openxri.XRISegment;
import org.openxri.config.ComponentRegistry;
import org.openxri.config.PipelineRegistry;
import org.openxri.config.ServerConfig;
import org.openxri.config.impl.AbstractComponent;
import org.openxri.exceptions.ServerException;
import org.openxri.exceptions.ServerInternalException;
import org.openxri.exceptions.ServerNotFoundException;
import org.openxri.exceptions.StoreException;
import org.openxri.factories.ServerConfigFactory;
import org.openxri.pipeline.Pipeline;
import org.openxri.server.Server;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.store.StoreAttributable;
import org.openxri.store.StoreMountable;
import org.openxri.store.SubSegment;
import org.openxri.xml.ServerStatus;
import org.openxri.xml.Status;
import org.openxri.xml.XRD;
import org.openxri.xml.XRDS;

public abstract class AbstractServer
extends AbstractComponent
implements Server {
    protected static Log log = LogFactory.getLog((String)AbstractServer.class.getName());
    protected Store store = null;

    public AbstractServer(Properties properties) {
        super(properties);
    }

    public void init() {
        log.trace((Object)"init()");
        ComponentRegistry componentRegistry = ServerConfigFactory.getSingleton().getComponentRegistry();
        this.store = (Store)componentRegistry.getComponent(Store.class);
        log.trace((Object)"Done.");
    }

    public XRDS lookupSelfDescribing(String namespace, boolean signed) throws ServerException {
        Authority namespaceAuthority;
        String utf8Namespace;
        log.trace((Object)("lookupSelfDescribing(" + namespace + ")"));
        try {
            utf8Namespace = IRIUtils.IRItoXRI((String)IRIUtils.URItoIRI((String)namespace));
        }
        catch (Exception ex) {
            ServerInternalException ex2 = new ServerInternalException("Unsupported encoding in namespace: " + ex.getMessage(), ex);
            log.warn((Object)"", (Throwable)ex2);
            throw ex2;
        }
        GCSAuthority authorityPath = new GCSAuthority(utf8Namespace);
        try {
            namespaceAuthority = this.store.localLookup((XRIAuthority)authorityPath);
        }
        catch (StoreException ex) {
            ServerInternalException ex2 = new ServerInternalException("Error while finding namespace authority " + namespace + ".", ex);
            log.warn((Object)"", (Throwable)ex2);
            throw ex2;
        }
        if (namespaceAuthority == null) {
            ServerNotFoundException ex = new ServerNotFoundException("Namespace authority " + namespace + " not found.");
            log.warn((Object)"", (Throwable)ex);
            throw ex;
        }
        XRDS xrds = new XRDS();
        boolean ret = this.initXRDS(xrds, namespace, signed);
        if (ret) {
            log.debug((Object)"Subclass handled XRDS completely. Returning it without any more work.");
            return xrds;
        }
        for (int i = 0; i < 1; ++i) {
            try {
                XRD xrd = new XRD();
                ret = this.initXRD(xrd, namespaceAuthority, namespace, signed);
                if (ret) {
                    log.debug((Object)"Subclass handled XRD completely. Returning it without any more work.");
                    xrds.add(xrd);
                    break;
                }
                ServerConfig serverConfig = ServerConfigFactory.getSingleton();
                PipelineRegistry pipelineRegistry = serverConfig == null ? null : serverConfig.getPipelineRegistry();
                Pipeline lookupPipeline = null;
                if (this.store instanceof StoreAttributable) {
                    StoreAttributable storeAttributable = (StoreAttributable)((Object)this.store);
                    String pipelineName = storeAttributable.getAuthorityAttributes(namespaceAuthority).get("override-lookup-pipeline");
                    if (pipelineRegistry != null && pipelineName != null) {
                        lookupPipeline = pipelineRegistry.getPipelineByName(pipelineName);
                    }
                }
                if (pipelineRegistry != null && lookupPipeline == null) {
                    lookupPipeline = pipelineRegistry.getDefaultLookupPipeline();
                }
                xrd = lookupPipeline.execute(this.store, xrd, null, null, namespace, namespaceAuthority, false);
                this.finishXRD(xrd, namespaceAuthority, null, null, signed);
                if (xrd == null) {
                    xrds.add(AbstractServer.makeNotFoundXrd(namespace));
                    break;
                }
                xrds.add(xrd);
                continue;
            }
            catch (Exception ex) {
                log.error((Object)"", (Throwable)ex);
                xrds.add(AbstractServer.makeExceptionXrd(namespace, ex));
                break;
            }
        }
        this.finishXRDS(xrds, namespace, signed);
        log.trace((Object)"Done.");
        return xrds;
    }

    public XRDS lookupByNamespace(String namespace, String query, boolean signed) throws ServerException {
        String utf8Query;
        Authority parentAuthority;
        String utf8Namespace;
        log.debug((Object)("lookupByNamespace(" + namespace + "," + query + ")"));
        try {
            utf8Namespace = IRIUtils.IRItoXRI((String)IRIUtils.URItoIRI((String)namespace));
        }
        catch (Exception ex) {
            ServerInternalException ex2 = new ServerInternalException("Unsupported encoding in namespace: " + ex.getMessage(), ex);
            log.warn((Object)"", (Throwable)ex2);
            throw ex2;
        }
        GCSAuthority authorityPath = new GCSAuthority(utf8Namespace);
        try {
            parentAuthority = this.store.localLookup((XRIAuthority)authorityPath);
            if (parentAuthority == null) {
                throw new ServerNotFoundException("Namespace authority " + namespace + " not found.");
            }
        }
        catch (StoreException ex) {
            ServerInternalException ex2 = new ServerInternalException("Error while finding namespace authority " + namespace + ": " + ex.getMessage(), ex);
            log.warn((Object)"", (Throwable)ex2);
            throw ex2;
        }
        XRDS xrds = new XRDS();
        boolean ret = this.initXRDS(xrds, query, signed);
        if (ret) {
            log.debug((Object)"Subclass handled XRDS completely. Returning it without any more work.");
            return xrds;
        }
        try {
            utf8Query = IRIUtils.IRItoXRI((String)IRIUtils.URItoIRI((String)query));
        }
        catch (Exception ex) {
            ServerInternalException ex2 = new ServerInternalException("Unsupported encoding in query: " + ex.getMessage(), ex);
            log.warn((Object)"", (Throwable)ex2);
            throw ex2;
        }
        XRISegment segment = new XRISegment(utf8Query);
        for (int i = 0; i < segment.getNumSubSegments(); ++i) {
            String subSegmentName = segment.getSubSegmentAt(i).toString();
            try {
                XRD xrd = new XRD();
                SubSegment subSegment = null;
                Authority authority = null;
                if (parentAuthority != null) {
                    subSegment = this.store.findSubSegment(parentAuthority, subSegmentName);
                }
                if (subSegment != null) {
                    authority = this.store.getSubSegmentAuthority(subSegment);
                }
                if (ret = this.initXRD(xrd, parentAuthority, subSegmentName, signed)) {
                    log.debug((Object)"Subclass handled XRD completely. Returning it without any more work.");
                    xrds.add(xrd);
                    continue;
                }
                ServerConfig serverConfig = ServerConfigFactory.getSingleton();
                PipelineRegistry pipelineRegistry = serverConfig == null ? null : serverConfig.getPipelineRegistry();
                Pipeline lookupPipeline = null;
                if (this.store instanceof StoreAttributable) {
                    StoreAttributable storeAttributable = (StoreAttributable)((Object)this.store);
                    String pipelineName = storeAttributable.getAuthorityAttributes(parentAuthority).get("override-lookup-pipeline");
                    if (pipelineRegistry != null && pipelineName != null) {
                        lookupPipeline = pipelineRegistry.getPipelineByName(pipelineName);
                    }
                }
                if (pipelineRegistry != null && lookupPipeline == null) {
                    lookupPipeline = pipelineRegistry.getDefaultLookupPipeline();
                }
                xrd = lookupPipeline.execute(this.store, xrd, segment, parentAuthority, subSegmentName, authority, false);
                this.finishXRD(xrd, parentAuthority, subSegment, authority, signed);
                parentAuthority = authority;
                if (xrd == null) {
                    if (i > 0) break;
                    xrds.add(AbstractServer.makeNotFoundXrd(subSegmentName));
                    break;
                }
                xrds.add(xrd);
                continue;
            }
            catch (Exception ex) {
                log.error((Object)"", (Throwable)ex);
                xrds.add(AbstractServer.makeExceptionXrd(subSegmentName, ex));
                break;
            }
        }
        this.finishXRDS(xrds, query, signed);
        log.debug((Object)"Done.");
        return xrds;
    }

    public XRDS lookupByPath(String path, boolean signed) throws ServerException {
        log.debug((Object)("lookupByPath(" + path + ")"));
        XRDS xrds = new XRDS();
        boolean ret = this.initXRDS(xrds, null, signed);
        if (ret) {
            log.debug((Object)"Subclass handled XRDS completely. Returning it without any more work.");
            return xrds;
        }
        Authority[] authorities = new Authority[]{};
        if (this.store instanceof StoreMountable) {
            try {
                StoreMountable storeMountable = (StoreMountable)((Object)this.store);
                authorities = storeMountable.listAuthoritiesByPath(path);
            }
            catch (StoreException ex) {
                ServerInternalException ex2 = new ServerInternalException("Error while listing mounted authorities.", ex);
                log.warn((Object)"", (Throwable)ex2);
                throw ex2;
            }
        }
        for (int i = 0; i < authorities.length; ++i) {
            String subSegmentName = path;
            try {
                XRD xrd = new XRD();
                Authority authority = authorities[i];
                ret = this.initXRD(xrd, null, subSegmentName, signed);
                if (ret) {
                    log.debug((Object)"Subclass handled XRD completely. Returning it without any more work.");
                    xrds.add(xrd);
                    continue;
                }
                ServerConfig serverConfig = ServerConfigFactory.getSingleton();
                PipelineRegistry pipelineRegistry = serverConfig == null ? null : serverConfig.getPipelineRegistry();
                Pipeline lookupPipeline = null;
                if (this.store instanceof StoreAttributable) {
                    StoreAttributable storeAttributable = (StoreAttributable)((Object)this.store);
                    String pipelineName = storeAttributable.getAuthorityAttributes(authority).get("override-lookup-pipeline");
                    if (pipelineRegistry != null && pipelineName != null) {
                        lookupPipeline = pipelineRegistry.getPipelineByName(pipelineName);
                    }
                }
                if (pipelineRegistry != null && lookupPipeline == null) {
                    lookupPipeline = pipelineRegistry.getDefaultLookupPipeline();
                }
                xrd = lookupPipeline.execute(this.store, xrd, null, null, subSegmentName, authority, false);
                this.finishXRD(xrd, null, null, authority, signed);
                if (xrd == null) {
                    xrds.add(AbstractServer.makeNotFoundXrd(subSegmentName));
                    break;
                }
                xrds.add(xrd);
                continue;
            }
            catch (Exception ex) {
                log.error((Object)"", (Throwable)ex);
                xrds.add(AbstractServer.makeExceptionXrd(subSegmentName, ex));
                break;
            }
        }
        this.finishXRDS(xrds, null, signed);
        log.debug((Object)"Done.");
        return xrds;
    }

    public static XRD makeNotFoundXrd(String subSegmentName) {
        XRD xrd = new XRD();
        xrd.setQuery(subSegmentName);
        xrd.setStatus(new Status("222", "No descriptor found for this query."));
        xrd.setServerStatus(new ServerStatus("222", "No descriptor found for this query."));
        return xrd;
    }

    public static XRD makeExceptionXrd(String subSegmentName, Exception ex) {
        XRD xrd = new XRD();
        String text = ex.getMessage();
        if (text == null || text.trim().equals("")) {
            text = "An internal error occurred: " + ex.getClass().getName();
        }
        xrd.setQuery(subSegmentName);
        xrd.setStatus(new Status("300", text));
        xrd.setServerStatus(new ServerStatus("300", text));
        return xrd;
    }

    protected abstract boolean initXRDS(XRDS var1, String var2, boolean var3) throws ServerInternalException;

    protected abstract void finishXRDS(XRDS var1, String var2, boolean var3) throws ServerInternalException;

    protected abstract boolean initXRD(XRD var1, Authority var2, String var3, boolean var4) throws ServerInternalException;

    protected abstract void finishXRD(XRD var1, Authority var2, SubSegment var3, Authority var4, boolean var5) throws ServerInternalException;
}

