/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.server.impl;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.openxri.exceptions.ServerInternalException;
import org.openxri.saml.Assertion;
import org.openxri.saml.Attribute;
import org.openxri.saml.AttributeStatement;
import org.openxri.saml.Conditions;
import org.openxri.saml.NameID;
import org.openxri.saml.Subject;
import org.openxri.server.impl.BasicServer;
import org.openxri.store.Authority;
import org.openxri.store.SubSegment;
import org.openxri.util.DOMUtils;
import org.openxri.xml.XRD;
import org.openxri.xml.XRDS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TrustedServer
extends BasicServer {
    protected static Log log = LogFactory.getLog((String)TrustedServer.class.getName());
    public static final String CONFIG_CERTIFICATE_LOCATION = "certificate.location";
    public static final String CONFIG_PRIVATE_KEY_LOCATION = "private.key.location";
    public static final String CONFIG_SAML_ISSUER = "saml.issuer";
    private String keyInfo;
    private String keyLocation;
    private String certificateLocation;
    private String samlIssuer;

    public TrustedServer(Properties properties) {
        super(properties);
    }

    public void init() {
        super.init();
        this.keyLocation = this.properties.getProperty(CONFIG_PRIVATE_KEY_LOCATION);
        this.certificateLocation = this.properties.getProperty(CONFIG_CERTIFICATE_LOCATION);
        this.samlIssuer = this.properties.getProperty(CONFIG_SAML_ISSUER);
        X509Certificate[] oCertChain = this.getCertificateChain();
        try {
            DocumentImpl oDoc = new DocumentImpl();
            KeyInfo oKeyInfo = new KeyInfo((Document)oDoc);
            X509Data oData = new X509Data((Document)oDoc);
            oData.addCertificate(oCertChain[oCertChain.length - 1]);
            oKeyInfo.add(oData);
            this.keyInfo = DOMUtils.toString((Element)oKeyInfo.getElement(), (boolean)false, (boolean)true);
        }
        catch (Exception oEx) {
            log.warn((Object)"Unable to create KeyInfo object for local authorities");
        }
    }

    protected boolean initXRDS(XRDS xrds, String query, boolean bSigned) throws ServerInternalException {
        if (bSigned && this.getPrivateKey() == null) {
            ServerInternalException ex = new ServerInternalException("Server not configured for trusted resolution");
            log.warn((Object)ex);
            throw ex;
        }
        return super.initXRDS(xrds, query, bSigned);
    }

    protected void finishXRD(XRD xrd, Authority parentAuthority, SubSegment subSegment, Authority authority, boolean bSigned) throws ServerInternalException {
        super.finishXRD(xrd, parentAuthority, subSegment, authority, bSigned);
        xrd.genXmlID();
        if (bSigned && this.getPrivateKey() != null) {
            try {
                Assertion oAssertion = this.createAssertion(xrd.getXmlID(), "", subSegment.getName());
                xrd.setSAMLAssertion(oAssertion);
                xrd.sign(this.getPrivateKey());
            }
            catch (Exception oEx) {
                log.warn((Object)("Unable to sign descriptor: " + oEx));
            }
        }
    }

    private Assertion createAssertion(String sXMLID, String sParentID, String sResolved) {
        log.debug((Object)("createAssertion(" + sXMLID + "," + sParentID + "," + sResolved + ")"));
        Subject oSubject = new Subject();
        NameID oName = new NameID("NameID");
        oName.setNameQualifier(sParentID);
        oName.setValue(sResolved);
        oSubject.setNameID(oName);
        AttributeStatement oAttrStatement = new AttributeStatement();
        Attribute oAttr = new Attribute();
        oAttr.setValue("#" + sXMLID);
        oAttr.setName("xri://$xrd*($v*2.0)");
        oAttrStatement.setAttribute(oAttr);
        Conditions oConditions = new Conditions();
        Assertion oXRIAssertion = new Assertion();
        oXRIAssertion.setIssueInstant(DOMUtils.toXMLDateTime((Date)new Date()));
        NameID oIssuer = new NameID("Issuer");
        oIssuer.setValue(this.samlIssuer);
        oXRIAssertion.setIssuer(oIssuer);
        oXRIAssertion.setSubject(oSubject);
        oXRIAssertion.setAttrStatement(oAttrStatement);
        oXRIAssertion.setConditions(oConditions);
        log.debug((Object)"Done.");
        return oXRIAssertion;
    }

    protected X509Certificate[] getCertificateChain() {
        FileInputStream certStream = null;
        Collection<? extends Certificate> certs = null;
        try {
            certStream = new FileInputStream(this.certificateLocation);
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            certs = factory.generateCertificates(certStream);
            X509Certificate[] certChain = new X509Certificate[certs.size()];
            Iterator<? extends Certificate> certIter = certs.iterator();
            int i = 0;
            while (certIter.hasNext()) {
                certChain[i] = (X509Certificate)certIter.next();
                ++i;
            }
            X509Certificate[] x509CertificateArray = certChain;
            return x509CertificateArray;
        }
        catch (Exception e) {
            throw new RuntimeException("XRI Server Setup Error: Failed to read certificate chain: ", e);
        }
        finally {
            if (certStream != null) {
                try {
                    certStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    protected PrivateKey getPrivateKey() {
        try {
            FileInputStream keyStream = new FileInputStream(this.keyLocation);
            ByteArrayOutputStream keyBytes = new ByteArrayOutputStream();
            int availableBytes = keyStream.available();
            while (availableBytes > 0) {
                byte[] bytes = new byte[availableBytes];
                keyStream.read(bytes);
                keyBytes.write(bytes);
                availableBytes = keyStream.available();
            }
            byte[] derKey = keyBytes.toByteArray();
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(derKey);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new RuntimeException("XRI Server Setup Error: Failed to read private key: ", e);
        }
    }
}

