/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openxri.config.ComponentRegistry;
import org.openxri.config.ServerConfig;
import org.openxri.factories.ServerConfigFactory;
import org.openxri.plugin.Plugin;
import org.openxri.server.Server;
import org.openxri.urimapper.URIMapper;
import org.openxri.urimapper.URIMapperRequest;
import org.openxri.urimapper.URIMapperResult;
import org.openxri.xml.XRDS;

public class XRIServlet
extends HttpServlet {
    private static final long serialVersionUID = 7240238001182896739L;
    protected static Log log = LogFactory.getLog((String)XRIServlet.class.getName());
    private ServerConfig serverConfig;
    private URIMapper uriMapper;
    protected Server server;
    protected Plugin plugin;

    public void init() throws ServletException {
        ServletConfig servletConfig = this.getServletConfig();
        try {
            this.serverConfig = ServerConfigFactory.initSingleton(servletConfig);
        }
        catch (Exception ex) {
            throw new ServletException("Cannot initialize server configuration: " + ex.getMessage(), (Throwable)ex);
        }
        this.init(this.serverConfig);
    }

    public void init(ServerConfig serverConfig) {
        log.trace((Object)"init()");
        ComponentRegistry componentRegistry = serverConfig.getComponentRegistry();
        this.server = (Server)componentRegistry.getComponent(Server.class);
        this.uriMapper = (URIMapper)componentRegistry.getComponent(URIMapper.class);
        this.plugin = (Plugin)componentRegistry.getComponent(Plugin.class);
        log.trace((Object)"Done.");
    }

    public void destroy() {
        log.trace((Object)"destroy()");
        log.trace((Object)"Done.");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String query;
        log.trace((Object)"doGet()");
        boolean signed = XRIServlet.checkSigned(request);
        XRDS xrds = null;
        URIMapperResult data = this.uriMapper.parseRequest(new URIMapperRequest(request));
        String namespace = data == null ? null : data.getNamespace();
        String string = query = data == null ? null : data.getQuery();
        if (namespace != null && namespace.trim().equals("")) {
            namespace = null;
        }
        if (query != null && query.trim().equals("")) {
            query = null;
        }
        String path = request.getRequestURI().substring(request.getContextPath().length() + 1);
        try {
            if (namespace != null && query == null) {
                log.debug((Object)"Looking up self-describing descriptor.");
                xrds = this.server.lookupSelfDescribing(namespace, signed);
            }
            if (namespace != null && query != null) {
                log.debug((Object)"Looking up descriptor by namespace and query.");
                xrds = this.server.lookupByNamespace(namespace, query, signed);
            }
            if (namespace == null && query == null) {
                log.debug((Object)"Looking up descriptor by path.");
                xrds = this.server.lookupByPath(path, signed);
            }
        }
        catch (Exception ex) {
            log.warn((Object)"Internal server problem during resolution.", (Throwable)ex);
            response.sendError(500, ex.getMessage());
            return;
        }
        if (xrds == null || xrds.getNumXRD() < 1) {
            if (this.plugin == null) {
                log.warn((Object)"No plugin installed.");
                response.sendError(400, "Invalid request.");
                return;
            }
            log.debug((Object)"Forwarding request to plugin.");
            boolean ret = this.plugin.processCustomRequest(request, response);
            if (ret) {
                log.debug((Object)"Plugin successfully handled the request.");
                return;
            }
            log.warn((Object)"Plugin failed to handle the request.");
            response.sendError(400, "Plugin failed to handle the request.");
            return;
        }
        String body = xrds.toString();
        log.debug((Object)"Resolution successful. Sending descriptor.");
        response.setStatus(200);
        response.setContentType("application/xrds+xml; charset=UTF-8");
        response.getOutputStream().write(body.getBytes("UTF-8"));
        response.flushBuffer();
    }

    public static boolean checkSigned(HttpServletRequest request) {
        String sAccept = request.getHeader("Accept");
        return false;
    }
}

