/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.store.impl.db;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;
import org.openxri.util.DOMUtils;
import org.openxri.xml.XRD;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XRDType
implements UserType {
    private static Log log = LogFactory.getLog((String)XRDType.class.getName());
    private DocumentBuilder builder;

    public XRDType() throws HibernateException {
        log.trace((Object)"XRDType()");
        try {
            this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new HibernateException("Cannot initialize XRD type.", (Throwable)ex);
        }
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        XRD xrd;
        log.trace((Object)"assemble()");
        if (cached == null) {
            return null;
        }
        String xrdText = (String)((Object)cached);
        try {
            Document document = this.builder.parse(xrdText);
            Element element = document.getDocumentElement();
            xrd = new XRD(element, false);
        }
        catch (Exception ex) {
            throw new HibernateException("Cannot assemble xrd.", (Throwable)ex);
        }
        return xrd;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        String xrdText;
        log.trace((Object)"disassemble()");
        if (value == null) {
            return null;
        }
        XRD xrd = (XRD)value;
        try {
            Document doc = this.builder.newDocument();
            Element element = xrd.toDOM(doc);
            doc.appendChild(element);
            xrdText = DOMUtils.toString((Element)element, (boolean)true, (boolean)true);
        }
        catch (Exception ex) {
            throw new HibernateException("Cannot disassemble xrd.", (Throwable)ex);
        }
        return xrdText;
    }

    public Object deepCopy(Object value) throws HibernateException {
        log.trace((Object)"deepCopy()");
        if (value == null) {
            return null;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(((XRD)value).toString())));
            XRD copy = new XRD();
            copy.fromDOM(document.getDocumentElement());
            return copy;
        }
        catch (Exception ex) {
            throw new HibernateException((Throwable)ex);
        }
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        log.trace((Object)"equals()");
        if (x == null || y == null) {
            return false;
        }
        if (x == y) {
            return true;
        }
        XRD xrd1 = (XRD)x;
        XRD xrd2 = (XRD)y;
        boolean result = xrd1.toString().equals(xrd2.toString());
        log.trace((Object)("Done: " + result));
        return result;
    }

    public int hashCode(Object x) throws HibernateException {
        log.trace((Object)"hashCode()");
        if (x == null) {
            return 0;
        }
        XRD xrd = (XRD)x;
        return xrd.hashCode();
    }

    public boolean isMutable() {
        log.trace((Object)"isMutable()");
        return true;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        XRD xrd;
        block5: {
            log.trace((Object)"nullSafeGet()");
            String str = rs.getString(names[0]);
            try {
                if (str != null) {
                    Document document = this.builder.parse(new ByteArrayInputStream(str.getBytes()));
                    Element element = document.getDocumentElement();
                    try {
                        xrd = new XRD(element, false);
                        break block5;
                    }
                    catch (Exception ex) {
                        log.error((Object)ex);
                        throw ex;
                    }
                }
                xrd = null;
            }
            catch (Exception ex) {
                throw new HibernateException("Cannot retrieve XRD.", (Throwable)ex);
            }
        }
        return xrd;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        block5: {
            log.trace((Object)"nullSafeSet()");
            XRD xrd = (XRD)value;
            try {
                if (xrd != null) {
                    Element element;
                    Document doc = this.builder.newDocument();
                    try {
                        element = xrd.toDOM(doc);
                    }
                    catch (Exception ex) {
                        log.error((Object)ex);
                        throw ex;
                    }
                    doc.appendChild(element);
                    String providerIdText = DOMUtils.toString((Element)element, (boolean)true, (boolean)true);
                    st.setString(index, providerIdText);
                    break block5;
                }
                st.setString(index, null);
            }
            catch (Exception ex) {
                throw new HibernateException("Cannot store xrd.", (Throwable)ex);
            }
        }
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        log.trace((Object)"replace()");
        if (original == null) {
            return null;
        }
        XRD xrd = (XRD)original;
        return xrd.clone();
    }

    public Class<?> returnedClass() {
        log.trace((Object)"returnedClass()");
        return XRD.class;
    }

    public int[] sqlTypes() {
        log.trace((Object)"sqlTypes()");
        return new int[]{2005};
    }
}

