/** 
 * Copyright (c) 2008 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.rpps.core.impl;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.AuthenticationRequiredException;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.IComplexClaim;
import org.eclipse.higgins.icard.IComplexClaimType;
import org.eclipse.higgins.icard.ISimpleClaim;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.IUIDescriptor;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.rpps.core.tobj.PropertyTO;

/**
 * 
 * Some fixes are incompatible with old AIR selector, AIR Selector will be fixed, but some customers might not update
 * AIR selector. We should prevent the same situation in the future, so Tom added WWM-1158 @see
 * http://graceland.parityinc.net:8090/browse/WWM-1158 . I tend to use Web Services Repository.
 * 
 * IT MUST BE TEMPORARY solution :)
 * 
 * @author Alexander Yuhimenko
 * 
 */
public class ConvertHelperAIRICM {

	private static final Log LOG = LogFactory.getLog(ConvertHelperAIRICM.class);

	/**
	 *Fixed org.eclipse.higgins.rpps.core.impl.ConvertHelper.getSimpleValues
	 * 
	 * 
	 * Gets the simple values from the claim object.
	 * 
	 * @param claim
	 *            the claim object.
	 * @param size
	 *            the size of the value array.
	 * @return the string array of values.
	 */
	public static String[] getSimpleValues(final IClaim claim, int size) {
		if (claim instanceof ISimpleClaim) {
			String[] values = new String[size];
			List claimValues = ((ISimpleClaim) claim).getValues();
			for (int i = 0; i < claimValues.size(); i++) {
				values[i] = claimValues.get(i).toString();
			}
			return values;
		}
		return null;
	}

	/**
	 * Copy/past org.eclipse.higgins.rpps.core.impl.ConvertHelper
	 * 
	 * @see Converts the card's claim to the property transfer object
	 * 
	 * @param card
	 * @param isCatchAuthentication
	 * @return array of PropertyTO
	 * @throws AuthenticationRequiredException
	 * @throws CardException
	 */

	public static Map convertClaims_to_PropertyTO(ICard card, boolean isCatchAuthentication, Iterator claimIterator)
			throws AuthenticationRequiredException, CardException {
		Map props = new LinkedHashMap();
		if (card != null) {

			for (Iterator it = claimIterator; it != null && it.hasNext();) {
				Object claimTypeObject = it.next();
				String claimTypeString;
				IClaimType claimType = null;
				if (claimTypeObject instanceof IClaimType) {
					claimTypeString = ((IClaimType) claimTypeObject).getType();
					claimType = (IClaimType) claimTypeObject;
				} else {
					claimTypeString = claimTypeObject.toString();
				}

				IClaim claim = null;
				try {
					claim = card.getClaim(claimTypeString);
				} catch (InvalidTypeException e) {
					LOG.info(e);
				} catch (AuthenticationRequiredException e) {
					if (isCatchAuthentication)
						throw e;
				} catch (AuthenticationException e) {
					if (isCatchAuthentication)
						throw e;
				} catch (CardException e) {
					LOG.error(e);
					break;
				}

				// get claimType
				if (claim != null) {
					claimType = claim.getType();
				} else {
					for (Iterator iterator = card.getSupportedClaimTypes(); iterator.hasNext();) {
						IClaimType item = (IClaimType) iterator.next();
						if (claimTypeString.equals(item.getType())) {
							claimType = item;
							break;
						}
					}
				}

				if (claimType != null) {
					if (claimType.isSimple()) {
						IUIDescriptor uiDesc = ((ISimpleClaimType) claimType).getUIDescriptor();
						String[] optionalValues = null;
						if (uiDesc.getOptionalValues() != null && uiDesc.getOptionalValues().size() > 0) {
							optionalValues = (String[]) uiDesc.getOptionalValues().toArray(
									new String[uiDesc.getOptionalValues().size()]);
						}
						props.put(claimTypeString, new PropertyTO(claimType.getDisplayName(), claimType.getType(),
								((ISimpleClaimType) claimType).getDataType().getName(), getSimpleValues(claim,
										((ISimpleClaimType) claimType).getMaxCardinality()), claimType.isVisible(),
								uiDesc.getType(), optionalValues, uiDesc.getPattern(), uiDesc.getInputMask()));
					} else {
						// this claim is complex
						props.put(claimTypeString, new PropertyTO(claimType.getDisplayName(), claimType.getType(),
								ConvertHelper
										.getComplexValues((IComplexClaimType) claimType, (IComplexClaim) claim,
												isCatchAuthentication, ((IComplexClaimType) claimType)
														.getSupportedClaimTypes()), claimType.isVisible()));
					}
				}
			}
		}

		return props;
	}

}
