/** 
 * Copyright (c) 2008 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.rpps.core.impl;

import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eclipse.higgins.rpps.core.RPPSServiceCore;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.IPersonalInformationCard;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.icard.policy.ICardSpacePolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.InformationCard;
import org.eclipse.higgins.keystore.registry.KeyStoreRegistry;
import org.eclipse.higgins.rpps.core.tobj.PropertyTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseCardTO;
import org.eclipse.higgins.rpps.core.tobj.UITokenServiceCredentialTO;
import org.eclipse.higgins.sts.client.PPIDHelper;
import org.eclipse.higgins.user.login.UserAccount;
import org.eclipse.higgins.user.profile.entity.CardInformation;
import org.eclipse.higgins.user.profile.entity.CardUsage;
import org.eclipse.higgins.user.profile.entity.WebForm;

/**
 * Some fixes are incompatible with old AIR selector, AIR Selector will be fixed, but some customers might not update
 * AIR selector. We should prevent the same situation in the future, so Tom added WWM-1158 @see
 * http://graceland.parityinc.net:8090/browse/WWM-1158 I tend to use Web Services Repository.
 * 
 * IT MUST BE TEMPORARY solution :)
 * 
 * @author Alexander Yuhimenko
 * 
 */
public class RppsServiceAIRICM extends RPPSServiceCore {

	private static final Log LOG = LogFactory.getLog(RppsServiceAIRICM.class);

	// /**
	// * Creates an RPPSServiceCoreImpl object.
	// *
	// * @return the RPPSServiceCoreImpl object
	// */
	// public static RppsServiceAIRICM getInstance(String userId, String password) throws AccessException {
	// return new RppsServiceAIRICM(userId, password);
	// }

	/**
	 * 
	 */
	public RppsServiceAIRICM() {
	}

	// /**
	// * @param userId
	// * @param password
	// * @throws AccessException
	// */
	// public RppsServiceAIRICM(String userId, String password) throws AccessException {
	// super(userId, password);
	// }

	/*
	 * (non-Javadoc)
	 * 
	 * Copy/past org.eclipse.higgins.rpps.core.impl.RppsService#convertICard_To_UIResponseCardTO
	 * 
	 * @see
	 * org.eclipse.higgins.rpps.core.impl.RppsService#convertICard_To_UIResponseCardTO(org.eclipse.higgins.icard.ICard,
	 * org.eclipse.higgins.userprofile.entity.WebForm, org.eclipse.higgins.icard.IPolicy,
	 * org.eclipse.higgins.rpps.core.impl.CardInformationRPPS, java.security.cert.X509Certificate[])
	 */
	@Override
	public UIResponseCardTO convertICard_To_UIResponseCardTO(UserAccount userAccount, final ICard icard,
			final WebForm webForm, final IPolicy policy, final CardInformation cardInformation,
			final X509Certificate[] sslCerts) {
		final UIResponseCardTO cardTO = new UIResponseCardTO();
		if (icard != null) {
			// sets uid
			cardTO.setCardId(icard.getCUID().toString());
			cardTO.setUid(icard.getCUID().toString());
			// sets name
			String nm = icard.getName();
			int k;
			nm = (k = nm.lastIndexOf('/')) > 0 ? nm.substring(k + 1) : nm;
			cardTO.setName(nm);
			// sets description
			cardTO.setDescription(icard.getDescription());
			// sets image
			cardTO.setImage(icard.getImage());
			// sets imagetype
			cardTO.setImagetype(icard.getImageType());

			cardTO.setIssuerName(icard.getIssuerName());

			cardTO.setType(icard.getType());

			final List supportedClaimTypeList = icard.getSupportedClaimTypesUris();

			if (supportedClaimTypeList != null && supportedClaimTypeList.size() > 0) {
				final String[] supportedClaimType = new String[supportedClaimTypeList.size()];
				supportedClaimTypeList.toArray(supportedClaimType);
				cardTO.setSupportedClaimTypes(supportedClaimType);
			}

			final UITokenServiceCredentialTO[] tokenservices = convertICredentials_to_UITokenServiceCredentialTO(
					userAccount, icard, cardInformation != null ? cardInformation.getCardCredential() : null, null);

			cardTO.setTokenservices(tokenservices);

			
//			if (cardInformation != null) {
//				Set cardUsageSet = cardInformation.getCUsage();
//				if (null != cardUsageSet) {
//					for (Iterator iterator = cardUsageSet.iterator(); iterator.hasNext();) {
//						CardUsage cardUsage = (CardUsage) iterator.next();
//						if (cardUsage.getForm().equals(webForm)) {
//							cardTO.setSaveCard(true);
//						}
//					}
//				}
//		}

				// final WebForm[] webForms = cardInformation.getWebForms();
				// if (webForms != null) {
				// for (int i = 0; i < webForms.length; i++) {
				// if (webForms[i].equals(webForm)) {
				// cardTO.setSaveCard(true);
				// }
				// }
				// }
			String PPID_CLAIM = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier";
			Map requiredMap = null;
			try {
				if (policy.getRequiredClaims() != null && policy.getRequiredClaims().size() > 0) {
					requiredMap = ConvertHelperAIRICM.convertClaims_to_PropertyTO(icard, false, policy
							.getRequiredClaims().iterator());
				}
			} catch (final Exception e) {
				LOG.error(e, e);
			}
			// if (requiredMap == null) {
			// requiredMap = new LinkedHashMap();
			// }
			if (policy instanceof ICardSpacePolicy) {
				final ICardSpacePolicy policyCS = (ICardSpacePolicy) policy;
				try {
					// calc user friendly ppid
					if (icard instanceof IPersonalInformationCard && requiredMap != null
							&& requiredMap.containsKey(PPID_CLAIM)) {
						String ppid = null;
						byte[] pinDigets = ((IPersonalInformationCard) icard).getPinDigest();
						if (pinDigets == null && sslCerts != null && sslCerts.length > 0 && webForm != null
								&& webForm.getUrl() != null) {
							String uriSite = webForm.getUrl().toString();
							byte[] ppidArray = PPIDHelper.computeClaimValuePPID((InformationCard) icard, sslCerts,
									KeyStoreRegistry.getInstance().getSecurityService().getCertStore(
											RppsHelper.getCallbackHandler(userAccount.getUserId())), uriSite);
							if (ppidArray != null) {
								ppid = PPIDHelper.getUserFriendlyPPID(ppidArray);
							}
						}
						if (ppid != null) {
							requiredMap
									.put(PPID_CLAIM, new PropertyTO("Site Specific Card ID", PPID_CLAIM, "".getClass()
											.getName(), new String[] { ppid }, true, 0, new String[] { "" }, "", ""));
						}
					}

					if (policyCS.getOptionalClaims() != null && policyCS.getOptionalClaims().size() > 0) {
						Map propMap = ConvertHelperAIRICM.convertClaims_to_PropertyTO(icard, false, policyCS
								.getOptionalClaims().iterator());
						if (propMap.size() > 0) {
							cardTO.setOptionalClaims(((PropertyTO[]) propMap.values().toArray(
									new PropertyTO[propMap.values().size()])));
						}
					}
				} catch (final Exception e) {
					LOG.error(e, e);
				}
			}

			try {
				if (requiredMap != null && requiredMap.size() > 0) {
					cardTO.setProperties((PropertyTO[]) requiredMap.values().toArray(
							new PropertyTO[requiredMap.values().size()]));
				}
			} catch (final Exception e) {
			}
		}
		return cardTO;
	}
}
