/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.rpps.utilities;

import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;

import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.provider.cardspace.common.STSFaultException;
import org.eclipse.higgins.sts.api.IFault;

/**
 * Soap utilities.
 * 
 * @author Alexander Yuhimenko
 * 
 */
public class SoapUtils {

	private static final Log LOG = LogFactory.getLog(SoapUtils.class);

	private static final String AUTHENTICATE_HEADER_PREFIX = "HWS ";

	/**
	 * 
	 */
	public static final String RPPS_SOAP_FAULT_NAMESPACE = "urn:RPPSService/wsdlRPPSService";

	/**
	 * Build SOAP Fault
	 * 
	 * @param e
	 *            - throwable instance
	 * @return SOAPFaultException
	 */
	public SOAPFaultException buildSoapFault(final Throwable e) {
		try {

			// create SOAPFault Detail
			// Detail detail = SOAPFactory.newInstance().createDetail();

			if (e instanceof STSFaultException) {
				// extract reason and detail from STSFault
				IFault fault = ((STSFaultException) e).getFault();
				// final StsFaultException stsFaultException = new StsFaultException();
				// // hard code action
				// tsFaultException.setAction("http://www.w3.org/2005/08/addressing/soap/fault");

				// check Fault
				if (fault != null) {
					StringBuffer errorCode = new StringBuffer("");
					if (null != fault.getCodePrefix()) {
						errorCode.append(fault.getCodePrefix());
					}
					// if (null != fault.getCodeNamespace()) {
					// errorCode.append(fault.getCodeNamespace());
					// }
					if (null != fault.getCodeLocalPart()) {
						errorCode.append(fault.getCodeLocalPart());
					}
					// detail.setTextContent(fault.getDetail());

					return new SOAPFaultException(new QName(fault.getCodeNamespace().toString(), errorCode.toString()),// faultcode
							fault.getReason(),// fault string
							"STS",// fault actor
							null);

					// stsFaultException.setCode(errorCode.toString());
					//
					// // TODO update sts IFault
					// // // add subCode, just soap 1.2 has it
					// // if (null != fault.getSubCode()) {
					// // stsFaultException.setSubcode(stsException.getFault().getSubCode().toString());
					// // }
					// stsFaultException.setSubcode("ic:UnknowException");
					//
					// stsFaultException.setDetailMessage(fault.getDetail());
					// stsFaultException.setReason(fault.getReason());

					// // new SOAPFaultException(new QName(fault.getCodeNamespace().toString(), errorCode.toString()),//
					// // fault
					// // fault.getReason(),// fault string
					// // "STS",// fault actor
					// // detail);
					// return new SOAPFaultException(new QName(RPPS_SOAP_FAULT_NAMESPACE, e.getClass().getName()), fault
					// .getReason(), "STS", detail);

				} else {
					return new SOAPFaultException(new QName(RPPS_SOAP_FAULT_NAMESPACE, e.getClass().getName()),// fault
							// code
							e.getMessage(),// fault string
							"STS",// fault actor
							null);

					// stsFaultException.setCode("S:Sender");
					// // set subCode just soap 1.2 has it
					// stsFaultException.setSubcode("ic:UnknowException");
					// stsFaultException.setDetailMessage(e.getMessage());
					// stsFaultException.setReason("Sorry, error retrieving Information Card");
				}
				// return stsFaultException;

			} else {
				return new SOAPFaultException(new QName(RPPS_SOAP_FAULT_NAMESPACE, e.getClass().getName()),// fault code
						e.getMessage(),// fault string
						"RPPS",// fault actor
						null);
			}
		} catch (Exception ex) {
			LOG.error(ex, ex);

			return new SOAPFaultException(new QName(RPPS_SOAP_FAULT_NAMESPACE, e.getClass().getName()),// fault code
					e.getMessage(),// fault string
					"RPPS",// fault actor
					null);
		}
	}

	/**
	 * 
	 * @param headerName
	 * @return
	 */
	public String getHeader(String headerName) {
		MessageContext msgCtx = MessageContext.getCurrentContext();
		HttpServletRequest req = (HttpServletRequest) msgCtx.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
		return req.getHeader(headerName);
	}

	/**
	 * Extract access token id from auth header.
	 * 
	 * @param authHeader
	 * @return
	 */
	public String getAuthTokenId(String authHeader) {
		if (null != authHeader && authHeader.trim().length() > 0
				&& authHeader.trim().startsWith(AUTHENTICATE_HEADER_PREFIX)) {
			return authHeader.trim().substring(AUTHENTICATE_HEADER_PREFIX.length());
		}
		return null;
	}

}
