/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.rpps.web;

import java.rmi.RemoteException;

import javax.xml.rpc.soap.SOAPFaultException;


import org.eclipse.higgins.rpps.core.tobj.CaptchaTO;
import org.eclipse.higgins.rpps.core.tobj.ResponseMessage;
import org.eclipse.higgins.rpps.core.tobj.UrlInformationAndBlackListTO;
import org.eclipse.higgins.sync.to.RevisionTO;

/**
 * Parity extended service.
 * 
 * 
 * @author Alexander Yuhimenko
 * 
 */
public interface RPPSServiceSEI extends org.eclipse.higgins.rpps.webservices.RPPSServiceSEI {

	/**
	 * @param userId
	 * @param password
	 * @param url
	 * @return
	 * @throws RemoteException
	 */
	ResponseMessage addUrlToBlackList(String userId, String password, String url) throws RemoteException;

	/**
	 * Web service operation. Generate and send user email with new password reset code. Support captcha validation.
	 * 
	 * This method is part of reset user password work-flow.
	 * 
	 * @see WWM-1264 RPPS Changes for password reset http://graceland.parityinc.net:8090/browse/WWM-1264
	 * 
	 * @param userIdentifier
	 * @param captchaId
	 * @param captchaResponse
	 * @throws SOAPFaultException
	 *             If captchaResponse is invalid. if couldn't send email. if userIdentifier is invalid.
	 */
	void generatePasswordResetCodeWithCaptcha(final String userIdentifier, final String captchaId,
			final String captchaResponse) throws SOAPFaultException;

	/**
	 * Generate CaptchaTO. This method is part of reset user password work-flow.
	 * 
	 * @see WWM-1264 RPPS Changes for password reset http://graceland.parityinc.net:8090/browse/WWM-1264
	 * @return CaptchaTO
	 * @throws SOAPFaultException
	 */
	CaptchaTO getCaptcha() throws SOAPFaultException;

	/**
	 * @param userId
	 * @param password
	 * @return
	 * @throws RemoteException
	 */
	UrlInformationAndBlackListTO getUrlInformationAndBlackList(String userId, String password) throws RemoteException;

	/**
	 * Update user password, requires password reset code for identify. Support captcha validation.
	 * 
	 * This method is part of reset user password work-flow.
	 * 
	 * @see WWM-1264 RPPS Changes for password reset http://graceland.parityinc.net:8090/browse/WWM-1264
	 * @param userIdentifier
	 * @param passwordResetCode
	 * @param newPassword
	 * @param captchaId
	 * @param captchaResponse
	 * @throws SOAPFaultException
	 */
	void modifyPasswordWithPasswordResetCodeAndCaptcha(final String userIdentifier, final String passwordResetCode,
			final String newPassword, final String captchaId, final String captchaResponse) throws SOAPFaultException;

	/**
	 * @param userId
	 * @param password
	 * @param url
	 * @return
	 * @throws RemoteException
	 */
	ResponseMessage removeUrlFromBlackList(String userId, String password, String url) throws SOAPFaultException;

	/**
	 * Return root revision.
	 * 
	 * @see WWM-1657: AIR ICM - cache timestamp check http://graceland.parityinc.net:8090/browse/WWM-1657
	 * 
	 * @param userId
	 * @param password
	 * @return
	 * @throws SOAPFaultException
	 */
	RevisionTO getRootRevision(String userId, String password) throws SOAPFaultException;

}
