/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.rpps.web;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.rmi.RemoteException;
import java.util.Locale;

import javax.xml.rpc.soap.SOAPFaultException;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.rpps.core.impl.RppsServiceAIRICM;
import org.eclipse.higgins.rpps.core.tobj.CaptchaTO;
import org.eclipse.higgins.rpps.core.tobj.ICardTO;
import org.eclipse.higgins.rpps.core.tobj.ResponseMessage;
import org.eclipse.higgins.rpps.core.tobj.StsFaultException;
import org.eclipse.higgins.rpps.core.tobj.UITokenServiceCredentialTO;
import org.eclipse.higgins.rpps.core.tobj.UrlInformationAndBlackListTO;
import org.eclipse.higgins.rpps.web.bean.CaptchaServiceSingleton;
import org.eclipse.higgins.rpps.webservices.SCRPPSServiceImpl;
import org.eclipse.higgins.sync.to.RevisionTO;
import org.eclipse.higgins.user.login.UserAccount;
import org.eclipse.higgins.user.profile.entity.Captcha;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class SCRPPSServiceImplAIRICM extends SCRPPSServiceImpl implements ISCRPPSServiceAIRICM {

	private static final Log LOG = LogFactory.getLog(SCRPPSServiceImplAIRICM.class);

	public RppsServiceAIRICM getRppsService() {
		return new RppsServiceAIRICM();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.parityinc.higgins.rpps.web.RPPSServiceSEI#getUrlInformationAndBlackList(java.lang.String,
	 * java.lang.String)
	 */
	public UrlInformationAndBlackListTO getUrlInformationAndBlackList() throws RemoteException {
		try {
			UserAccount account = getRppsService().authenticate(
					getSoapUtils().getAuthTokenId(getSoapUtils().getHeader(AUTHORIZATION_HEADER)));
			return getRppsService().getUrlInformationAndBlackList(account);
		} catch (Throwable e) {
			LOG.error(e, e);
			throw getSoapUtils().buildSoapFault(e);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.parityinc.higgins.rpps.web.RPPSServiceSEI#addUrlToBlackList(java.lang.String, java.lang.String,
	 * java.lang.String)
	 */
	public ResponseMessage addUrlToBlackList(final String url) throws RemoteException {
		try {
			UserAccount account = getRppsService().authenticate(
					getSoapUtils().getAuthTokenId(getSoapUtils().getHeader(AUTHORIZATION_HEADER)));

			return getRppsService().addUrlToBlackList(account, url);
		} catch (Throwable e) {
			LOG.error(e, e);
			throw getSoapUtils().buildSoapFault(e);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.rpps.webservices.RPPSServiceSEI#generatePasswordResetCodeWithCaptcha(java.lang.String,
	 * java.lang.String, java.lang.String)
	 */
	public void generatePasswordResetCodeWithCaptcha(final String userIdentifier, final String captchaId,
			final String captchaResponse) throws SOAPFaultException {
		try {
			getRppsService().validateCaptcha(captchaId, captchaResponse);
			// generate password reset code
			getRppsService().generatePasswordResetCode(userIdentifier);
		} catch (Throwable e) {
			LOG.error(e, e);
			throw getSoapUtils().buildSoapFault(e);
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.rpps.webservices.RPPSServiceSEI#getCaptcha()
	 */
	public CaptchaTO getCaptcha() throws SOAPFaultException {
		try {
			CaptchaTO captchaTO;
			captchaTO = new CaptchaTO();
			final Captcha captcha = getRppsService().createCaptcha();
			captchaTO.setId(captcha.getId());

			// build captcha image
			final BufferedImage challenge = CaptchaServiceSingleton.getInstance().getImageChallengeForID(
					captcha.getKey(), Locale.US);
			final ByteArrayOutputStream jpegOutputStream = new ByteArrayOutputStream();
			final JPEGImageEncoder jpegEncoder = JPEGCodec.createJPEGEncoder(jpegOutputStream);
			jpegEncoder.encode(challenge);
			captchaTO.setImage(jpegOutputStream.toByteArray());
			return captchaTO;
		} catch (Throwable e) {
			LOG.error(e, e);
			throw getSoapUtils().buildSoapFault(e);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.rpps.webservices.RPPSServiceImpl#getICardByIdAndTokenServiceCredential(java.lang.String,
	 * java.lang.String, java.lang.String, org.eclipse.higgins.rpps.core.tobj.UITokenServiceCredentialTO)
	 */
	public ICardTO getICardByIdAndTokenServiceCredential(final String cuid,
			final UITokenServiceCredentialTO userCredintial) throws StsFaultException, SOAPFaultException {
		try {
			UserAccount account = getRppsService().authenticate(
					getSoapUtils().getAuthTokenId(getSoapUtils().getHeader(AUTHORIZATION_HEADER)));
			return getRppsService().getICardByCUIDAndTokenServiceCredential(account, cuid, userCredintial);

		} catch (Throwable e) {
			LOG.error(e, e);
			throw getSoapUtils().buildSoapFault(e);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.higgins.rpps.webservices.RPPSServiceSEI#modifyPasswordWithPasswordResetCodeAndCaptcha(java.lang.String
	 * , java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public void modifyPasswordWithPasswordResetCodeAndCaptcha(final String userIdentifier,
			final String passwordResetCode, final String newPassword, final String captchaId,
			final String captchaResponse) throws SOAPFaultException {
		try {
			getRppsService().validateCaptcha(captchaId, captchaResponse);
			modifyPasswordWithPasswordResetCode(userIdentifier, passwordResetCode, newPassword);
		} catch (Throwable e) {
			LOG.error(e, e);
			throw getSoapUtils().buildSoapFault(e);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.parityinc.higgins.rpps.web.RPPSServiceSEI#removeUrlFromBlackList(java.lang.String, java.lang.String,
	 * java.lang.String)
	 */
	public ResponseMessage removeUrlFromBlackList(final String url) throws SOAPFaultException {
		try {
			UserAccount account = getRppsService().authenticate(
					getSoapUtils().getAuthTokenId(getSoapUtils().getHeader(AUTHORIZATION_HEADER)));

			return getRppsService().removeUrlFromBlackList(account, url);
		} catch (Throwable e) {
			LOG.error(e, e);
			throw getSoapUtils().buildSoapFault(e);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.parityinc.higgins.rpps.web.RPPSServiceSEI#getRootRevision(java.lang.String, java.lang.String)
	 */
	public RevisionTO getRootRevision() throws SOAPFaultException {
		try {
			UserAccount account = getRppsService().authenticate(
					getSoapUtils().getAuthTokenId(getSoapUtils().getHeader(AUTHORIZATION_HEADER)));

			return getRppsService().getRootRevision(account);
		} catch (Throwable e) {
			LOG.error(e, e);
			throw getSoapUtils().buildSoapFault(e);
		}
	}

}
