/** 
 * Copyright (c) 2009 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.rpps.webservices;

import javax.xml.rpc.soap.SOAPFaultException;

import org.eclipse.higgins.rpps.core.tobj.AccessTokenTO;
import org.eclipse.higgins.rpps.core.tobj.AuthCredentialTO;
import org.eclipse.higgins.rpps.core.tobj.CardInformationTO;
import org.eclipse.higgins.rpps.core.tobj.CardUsageTO;
import org.eclipse.higgins.rpps.core.tobj.CategoryTO;
import org.eclipse.higgins.rpps.core.tobj.ExtraTokenResponseTO;
import org.eclipse.higgins.rpps.core.tobj.FormatDescriptorTO;
import org.eclipse.higgins.rpps.core.tobj.ICardResponseTO;
import org.eclipse.higgins.rpps.core.tobj.ICardTO;
import org.eclipse.higgins.rpps.core.tobj.ICardTemplateTO;
import org.eclipse.higgins.rpps.core.tobj.ICardUpdateResponseTO;
import org.eclipse.higgins.rpps.core.tobj.ICardUpdateTO;
import org.eclipse.higgins.rpps.core.tobj.ICardsAndCategoryTO;
import org.eclipse.higgins.rpps.core.tobj.ImportCardInformationTO;
import org.eclipse.higgins.rpps.core.tobj.MapTO;
import org.eclipse.higgins.rpps.core.tobj.ResponseMessage;
import org.eclipse.higgins.rpps.core.tobj.SelectorAuthCredentialTO;
import org.eclipse.higgins.rpps.core.tobj.SelectorClientTO;
import org.eclipse.higgins.rpps.core.tobj.StsFaultException;
import org.eclipse.higgins.rpps.core.tobj.TokenResponseTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseCardTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseTO;
import org.eclipse.higgins.rpps.core.tobj.UITokenServiceCredentialTO;
import org.eclipse.higgins.rpps.core.tobj.UserProfileTO;
import org.eclipse.higgins.rpps.core.tobj.UsernamePasswordAuthCredentialTO;

/**
 * 
 * @author Alexander Yuhimenko
 * 
 */
public interface ISCRPPSServiceSE {

	CategoryTO addCategory(CategoryTO category) throws SOAPFaultException;

	void addClaimValuesMRU(String claimType, String claimValue) throws SOAPFaultException;

	boolean addUrlCardRelation(String cuid, String url) throws SOAPFaultException;

	SelectorClientTO addUserProfile(UserProfileTO userProfileTO, SelectorClientTO selectorClientTO,
			UsernamePasswordAuthCredentialTO authCredentialTO) throws SOAPFaultException;

	void addUserProfileFromHBX(String userId, String password) throws SOAPFaultException;

	FormatDescriptorTO checkImportStream(byte[] crd) throws SOAPFaultException;

	ICardTO clearCardCredential(String cuid) throws SOAPFaultException;

	boolean clearCardHistory(String cuid) throws SOAPFaultException;

	ICardTO createDuplicateICard(String cardName, String cuid, String pinCode) throws SOAPFaultException;

	ICardTO createICardByTemplate(ICardTemplateTO template) throws SOAPFaultException;

	String createICardFromHBX(String cardname) throws SOAPFaultException;

	void deleteAllICard() throws SOAPFaultException;

	boolean deleteCardHistoryRecord(String cuid, String url) throws SOAPFaultException;

	void deleteCategory(String categoryId) throws SOAPFaultException;

	ICardUpdateResponseTO deleteICard(String cuid) throws SOAPFaultException;

	boolean deleteUrlCardRelation(String cuid, String url) throws SOAPFaultException;

	boolean deleteUrlsCardsRelations(String cuid) throws SOAPFaultException;

	ResponseMessage deleteUserProfile() throws SOAPFaultException;

	ICardTO editPinCode(String cuid, String oldPinCode, String newPinCode) throws SOAPFaultException;

	byte[] exportICards(String formatID, String[] cards, UITokenServiceCredentialTO credential)
			throws SOAPFaultException;

	void generatePasswordResetCode(final String userIdentifier) throws SOAPFaultException;

	CardUsageTO[] getCardHistory(String cuid, int startFrom, int capacity, String orderBy, String orderDirection)
			throws SOAPFaultException;

	CardInformationTO getCardInformation(String cuid, int size) throws SOAPFaultException;

	CategoryTO[] getCategory() throws SOAPFaultException;

	MapTO[] getClaimValuesMRU() throws SOAPFaultException;

	ICardTO getDefaultPCard() throws SOAPFaultException;

	// TODO move it to utility
	String[] getHBXUIList(String version, String windowsName) throws SOAPFaultException;

	ICardTO getICardById(String cuid) throws SOAPFaultException;

	ICardTO getICardByIdAndTokenServiceCredential(String cuid, UITokenServiceCredentialTO userCredintial)
			throws StsFaultException, SOAPFaultException;

	UIResponseCardTO getICardClaims(String cuid, String policy, String typeofCredential, String[] credentialKey,
			String[] credentialValue) throws SOAPFaultException;

	ICardTemplateTO[] getICardCreationTemplate() throws SOAPFaultException;

	ICardResponseTO getICards() throws SOAPFaultException;

	ICardsAndCategoryTO getICardsAndCategoriesByUser() throws SOAPFaultException;

	ICardTO[] getICardsByCUIDs(String[] cuids) throws SOAPFaultException;

	ICardTO[] getICardsByFormat(String formatID) throws SOAPFaultException;

	FormatDescriptorTO[] getOutputFormats() throws SOAPFaultException;

	TokenResponseTO getTokenByUrl(String policy, String policytype, String sslCert, String url)
			throws SOAPFaultException;

	ExtraTokenResponseTO getTokenExtraByUrl(String policy, String policytype, String sslCert, String url)
			throws SOAPFaultException;

	TokenResponseTO getTokenObject(String policy, String policytype, String sslCert, String[] cuids,
			String typeofCredential, String[] credentialKey, String[] credentialValue) throws SOAPFaultException;

	UIResponseTO getUI(String url, String target, String sslCert, String policytype, String policy)
			throws SOAPFaultException;

	UserProfileTO getUserProfile() throws SOAPFaultException;

	ICardResponseTO importICardAsByteArray(byte[] crd) throws SOAPFaultException;

	ICardResponseTO importICards(byte[] crd, String formatID, UITokenServiceCredentialTO credential)
			throws SOAPFaultException;

	void importICardsAsString(String crd) throws SOAPFaultException;

	ResponseMessage modifyCategories(CategoryTO[] categories) throws SOAPFaultException;

	CategoryTO modifyCategory(CategoryTO category) throws SOAPFaultException;

	void modifyPasswordWithOldPassword(final String userIdentifier, final String oldPassword, final String newPassword)
			throws SOAPFaultException;

	void modifyPasswordWithPasswordResetCode(final String userIdentifier, final String passwordResetCode,
			final String newPassword) throws SOAPFaultException;

	UserProfileTO modifyUserProfile(UserProfileTO userProfile) throws SOAPFaultException;

	void removeClaimValuesMRU(String claimType, String claimValue) throws SOAPFaultException;

	ICardTO resetPinCode(String cuid, String oldPinCode) throws SOAPFaultException;

	boolean setCardCredential(String cuid, UITokenServiceCredentialTO tokenCredential) throws SOAPFaultException;

	void setDefaultPCard(String pcardId) throws SOAPFaultException;

	ICardTO setPinCode(String cuid, String pinCode) throws SOAPFaultException;

	ICardUpdateResponseTO[] updateClaimsAcrossCards(String[] claimTypes, String[] claimValues,
			ICardUpdateTO[] cardUpdate) throws SOAPFaultException;

	ICardTO updateICard(ICardTO icardTO) throws SOAPFaultException;

	ICardUpdateResponseTO[] updateICards(ICardTO[] icardTOs) throws SOAPFaultException;

	boolean userIdentifierExists(String userIdentifier) throws SOAPFaultException;

	/**
	 * Authenticate user by using AuthCredentialTO and start session.
	 * 
	 * @see http://wiki.eclipse.org/CardSync_Authentication
	 * @see https://camelot.parityinc.net/mediawiki/index.php/Serialized_Client
	 * 
	 * @param authCredentialTO
	 * @return
	 * @throws SOAPFaultException
	 */
	AccessTokenTO signIn(SelectorAuthCredentialTO authCredentialTO) throws SOAPFaultException;

	/**
	 * Close session by using accessTokenId.
	 * 
	 * @see http://wiki.eclipse.org/CardSync_Authentication.
	 * @see https://camelot.parityinc.net/mediawiki/index.php/Serialized_Client
	 * 
	 * @param accessTokenId
	 * @throws SOAPFaultException
	 */
	void signOut(String accessTokenId) throws SOAPFaultException;;

	/**
	 *Generate new one time password(OTP) and send it to user. Authenticate by using authCredentialTO. <br>
	 * Channel must be one of the following constant: EMAIL, SMS,CALL.
	 * 
	 * @see https://camelot.parityinc.net/mediawiki/index.php/Serialized_Client
	 * 
	 * @param authCredentialTO
	 * @param captchaId
	 * @param captchaResponse
	 * @param channel
	 * @throws SOAPFaultException
	 */
	void getOTP(UsernamePasswordAuthCredentialTO authCredentialTO, String captchaId, String captchaResponse,
			String channel) throws SOAPFaultException;

	// /**
	// * Dummy method, needs for auto-including SelectorAuthCredentialTO to wsdl by using axis tool - java2wsdl.
	// *
	// * @return
	// * @throws SOAPFaultException
	// */
	// SelectorAuthCredentialTO getSelectorAuthCredentialTO() throws SOAPFaultException;
	//
	// /**
	// * Dummy method, needs for auto-including UsernamePasswordAuthCredentialTO to wsdl by using axis tool - java2wsdl.
	// *
	// * @return
	// * @throws SOAPFaultException
	// */
	// UsernamePasswordAuthCredentialTO getUsernamePasswordAuthCredentialTO() throws SOAPFaultException;

	/**
	 * Check OTP and register new selector client.
	 * 
	 * @param authCredentialTO
	 * @param selectorClientTO
	 * @param otp
	 * @return
	 * @throws SOAPFaultException
	 */
	SelectorClientTO addSelectorClient(UsernamePasswordAuthCredentialTO authCredentialTO,
			SelectorClientTO selectorClientTO, String otp) throws SOAPFaultException;

	/**
	 * Update state and name of selector client.
	 * 
	 * @param selectorClientTO
	 * @return
	 */
	SelectorClientTO updateSelectorClient(SelectorClientTO selectorClientTO) throws SOAPFaultException;

	/**
	 *Delete SelectorClient.
	 * 
	 * @param userAccount
	 * @param selectorClientTO
	 * @throws SOAPFaultException
	 */
	void deleteSelectorClient(final SelectorClientTO selectorClientTO) throws SOAPFaultException;

	/**
	 * Return arrays of selector clients.
	 * 
	 * @return
	 * @throws SOAPFaultException
	 */
	SelectorClientTO[] getSelectorClients() throws SOAPFaultException;

	/**
	 * 
	 * @param crd
	 * @param formatID
	 * @param credential
	 * @param importFlag
	 * @return
	 * @throws SOAPFaultException
	 */
	ICardResponseTO importSelectedICards(final byte[] crd, final String formatID, final UITokenServiceCredentialTO credential,
			Boolean[] importFlag) throws SOAPFaultException;

	/**
	 * @param crd
	 * @param formatID
	 * @param credential
	 * @return
	 * @throws SOAPFaultException
	 */
	ImportCardInformationTO[] getImportingCardsInformation(final byte[] crd, final String formatID,
			final UITokenServiceCredentialTO credential) throws SOAPFaultException;

}