/** 
 * Copyright (c) 2008 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */

package org.eclipse.higgins.rpps.web.bean;

import java.awt.Font;
import java.net.URL;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;

import com.octo.captcha.component.image.backgroundgenerator.BackgroundGenerator;
import com.octo.captcha.component.image.backgroundgenerator.FunkyBackgroundGenerator;
import com.octo.captcha.component.image.color.RandomRangeColorGenerator;
import com.octo.captcha.component.image.fontgenerator.RandomFontGenerator;
import com.octo.captcha.component.image.textpaster.RandomTextPaster;
import com.octo.captcha.component.image.textpaster.TextPaster;
import com.octo.captcha.component.image.wordtoimage.ComposedWordToImage;
import com.octo.captcha.component.word.wordgenerator.RandomWordGenerator;
import com.octo.captcha.component.word.wordgenerator.WordGenerator;
import com.octo.captcha.engine.image.ListImageCaptchaEngine;
import com.octo.captcha.image.gimpy.GimpyFactory;
import com.octo.captcha.service.captchastore.EhcacheCaptchaStore;
import com.octo.captcha.service.image.DefaultManageableImageCaptchaService;
import com.octo.captcha.service.image.ImageCaptchaService;

/**
 * @author Alexander Yuhimenko
 * 
 */
public final class CaptchaServiceSingleton {
	/**
	 * CaptchaServiceSingleton
	 */
	private static ImageCaptchaService instance;

	/**
	 * Hide constructor
	 */
	private CaptchaServiceSingleton() {
	}

	static {
		CacheManager cacheManager = CacheManager.create(CaptchaServiceSingleton.class.getResource("ehcache.xml"));
		Cache cache = cacheManager.getCache("JCaptchaPasswordReset");

		instance = new DefaultManageableImageCaptchaService(new EhcacheCaptchaStore(cache),
				new ListImageCaptchaEngine() {
					protected void buildInitialFactories() {
						WordGenerator wgen = new RandomWordGenerator("ABCDEFGHJKMNPQRSTUVWXYZ23456789");
						RandomRangeColorGenerator cgen = new RandomRangeColorGenerator(new int[] { 0, 100 }, new int[] {
								0, 100 }, new int[] { 0, 100 });
						TextPaster textPaster = new RandomTextPaster(new Integer(5), new Integer(5), cgen, new Boolean(
								true));

						BackgroundGenerator backgroundGenerator = new FunkyBackgroundGenerator(new Integer(200),
								new Integer(80));

						Font[] fontsList = new Font[] { new Font("Arial", 0, 9), new Font("Tahoma", 0, 9),
								new Font("Verdana", 0, 9) };

						addFactory(new GimpyFactory(wgen, new ComposedWordToImage(new RandomFontGenerator(new Integer(
								20), new Integer(35), fontsList), backgroundGenerator, textPaster)));

					}
				}, 180, 100000, 75000);
	}

	/**
	 * @return CaptchaServiceSingleton
	 */
	public static ImageCaptchaService getInstance() {
		return instance;
	}

}
